/**
 * 
 */
package org.gcube.data.oai.tmplugin.repository.iterators;

import java.util.Iterator;
import java.util.List;

import org.gcube.data.oai.tmplugin.repository.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.gcube.common.OAIException;
import org.gcube.common.OAIRecordList;


/**
 * @author Fabio Simeoni
 *
 */
public abstract class SetIterator extends RecordIterator {

	private static final Logger log = LoggerFactory.getLogger(SetIterator.class);

	Iterator<Set> iterator; 
	
	public SetIterator(List<Set> sets) {
		iterator = sets.iterator();
	}
	
	
	@Override 
	public boolean hasNext() {
		
		try {
			if (records!=null && records.moreItems())
				return true;
		}
		catch (OAIException asFalseMovetoNextSet) {}
		
		while (iterator.hasNext()) {
				Set set = iterator.next();
				try {//read from next set
//					log.trace("retrieving records in set "+set.id());
					records = fetchRecords(set);
					log.trace("expecting to iterate over a max of "+records.getCompleteSize());	
					return hasNext();
				}
				catch(OAIException moveToNextSet) {
					log.error("could not list records for set "+set.id(),moveToNextSet);
				}
			}
		
		//no more sets to try
		return false;	
	}
	
	protected abstract OAIRecordList fetchRecords(Set set) throws OAIException;
	
	public long getCardinality() {
		return super.getCardinality();
	}
}
