/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.repository;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.OAIException;
import org.gcube.common.OAIRecord;
import org.gcube.common.OAIRecordList;
import org.gcube.common.OAIRepository;
import org.gcube.common.OAISet;
import org.gcube.common.OAISetList;
import org.gcube.data.oai.tmplugin.binders.OAIDCBinder;
import org.gcube.data.oai.tmplugin.repository.Repository;
import org.gcube.data.oai.tmplugin.repository.Set;
import org.gcube.data.oai.tmplugin.repository.Summary;
import org.gcube.data.oai.tmplugin.repository.iterators.RecordIterator;
import org.gcube.data.oai.tmplugin.repository.iterators.RepositoryIterator;
import org.gcube.data.oai.tmplugin.repository.iterators.SetIterator;
import org.gcube.data.oai.tmplugin.requests.Request;
import org.gcube.data.oai.tmplugin.utils.Constants;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.PipedStream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.exceptions.StreamSkipSignal;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRepository
implements Repository {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BaseRepository.class);
    private transient OAIRepository connection;
    private final String url;
    private final String metadataFormat;
    private transient String description;
    private transient String name;
    private transient int cardinality;
    Stream<OAIRecord> records;
    private OAIDCBinder binder;

    public BaseRepository(Request request) throws Exception {
        this.url = request.getRepositoryUrl();
        this.metadataFormat = request.getMetadataFormat();
        this.description = request.getDescription();
        this.name = request.getName();
        this.connect(this.url);
        this.binder = new OAIDCBinder(request);
    }

    @Override
    public String url() {
        return this.url;
    }

    public String metadataFormat() {
        return this.metadataFormat;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Tree get(String id, List<Set> sets) throws UnknownTreeException, Exception {
        try {
            OAIRecord record = this.connection.getRecord(id, this.metadataFormat);
            if (!sets.isEmpty()) {
                boolean inSomeSet = false;
                block2: for (int i = 0; i < record.getSetSpecCount(); ++i) {
                    for (Set set : sets) {
                        if (!record.getSetSpec(i).equals(set.id())) continue;
                        inSomeSet = true;
                        break block2;
                    }
                }
                if (!inSomeSet) {
                    throw new UnknownTreeException();
                }
            }
            return this.binder.bind(record);
        }
        catch (OAIException e) {
            throw new UnknownTreeException(id, (Throwable)e);
        }
    }

    @Override
    public Stream<Tree> getAllIn(List<Set> sets) {
        this.records = sets.isEmpty() ? new RepositoryIterator(){

            @Override
            protected OAIRecordList fetchRecords() throws OAIException {
                return BaseRepository.this.connection.listRecords(BaseRepository.this.metadataFormat);
            }

            public boolean isClosed() {
                return false;
            }
        } : new SetIterator(sets){

            @Override
            protected OAIRecordList fetchRecords(Set set) throws OAIException {
                return BaseRepository.this.connection.listRecords(BaseRepository.this.metadataFormat, null, null, set.id());
            }

            public boolean isClosed() {
                return false;
            }
        };
        Generator<OAIRecord, Tree> parser = new Generator<OAIRecord, Tree>(){

            public Tree yield(OAIRecord record) {
                try {
                    return BaseRepository.this.binder.bind(record);
                }
                catch (Exception e) {
                    throw new StreamSkipSignal();
                }
            }
        };
        PipedStream rec = Streams.pipe(this.records).through((Generator)parser);
        return rec;
    }

    @Override
    public Summary summary(List<Set> sets) throws Exception {
        RecordIterator records = null;
        records = sets.isEmpty() ? new RepositoryIterator(){

            @Override
            protected OAIRecordList fetchRecords() throws OAIException {
                return BaseRepository.this.connection.listIdentifiers(null, null, null, BaseRepository.this.metadataFormat);
            }

            public boolean isClosed() {
                return false;
            }
        } : new SetIterator(sets){

            @Override
            protected OAIRecordList fetchRecords(Set set) throws OAIException {
                return BaseRepository.this.connection.listIdentifiers(null, null, set.id(), BaseRepository.this.metadataFormat);
            }

            public boolean isClosed() {
                return false;
            }
        };
        Calendar lastUpdate = null;
        long cardinality = 0L;
        while (records.hasNext()) {
            try {
                OAIRecord record = (OAIRecord)records.next();
                if (record == null || record.deleted() || !record.isRecordValid() || record.getMetadata() == null) continue;
                ++cardinality;
                Calendar tempUpdate = Constants.getDate(record.getDatestamp());
                if (lastUpdate != null && !tempUpdate.after(lastUpdate)) continue;
                lastUpdate = tempUpdate;
            }
            catch (Exception e) {
                log.error("could not count record", (Throwable)e);
            }
        }
        if (lastUpdate == null) {
            throw new Exception();
        }
        return new Summary(lastUpdate, cardinality);
    }

    private void connect(String url) throws Exception {
        log.info("connecting to repository @ " + url);
        this.connection = new OAIRepository();
        try {
            this.connection.setBaseURL(url);
            this.name = this.connection.getRepositoryName();
            if (this.connection.getDescriptionCount() > 0) {
                this.description = this.connection.getDescription(0).getTextContent().trim();
            } else {
                log.info("0 records");
            }
        }
        catch (Exception e) {
            throw new Exception("could not connect to repository @ " + url, e);
        }
    }

    @Override
    public List<Set> getSetsWith(List<String> setIds) {
        boolean doAll = setIds.isEmpty();
        log.info(doAll ? "retrieving all sets" : "retrieving sets {}", setIds);
        ArrayList<String> done = new ArrayList<String>(setIds);
        ArrayList<Set> output = null;
        if (!setIds.isEmpty()) {
            output = new ArrayList<Set>();
            try {
                OAISetList OAISets = this.connection.listSets();
                while (OAISets.moreItems()) {
                    OAISet set = OAISets.getCurrentItem();
                    String setId = set.getSetSpec();
                    if (doAll || done.contains(setId)) {
                        String description = set.getSetDescriptionCount() > 0 ? set.getSetDescription(0).getTextContent() : null;
                        output.add(new Set(setId, set.getSetName(), description));
                        done.remove(setId);
                        if (!doAll && done.isEmpty()) break;
                    }
                    OAISets.moveNext();
                }
            }
            catch (OAIException e) {
                log.error("could not process sets ", (Throwable)e);
                throw new RuntimeException("could not process sets ", e);
            }
        }
        if (!done.isEmpty()) {
            log.error("unkwnon sets " + done);
            throw new RuntimeException("unkwnon sets " + done);
        }
        return output;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.url == null) {
            throw new IOException("invalid serialisation, missing respository url");
        }
        try {
            this.connect(this.url);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getCardinality() {
        long cardinality = 0L;
        try {
            cardinality = ((RepositoryIterator)this.records).getCardinality();
        }
        catch (Exception e) {
            cardinality = ((SetIterator)this.records).getCardinality();
        }
        return cardinality;
    }
}

