/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.accounting.service.resources;

import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.gcube.accounting.analytics.persistence.couchbase.AccountingPersistenceQueryCouchBase;
import org.gcube.data.publishing.accounting.service.AccountingInitializer;
import org.gcube.smartgears.ApplicationManagerProvider;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=AccountingInitializer.class)
@Path(value="query")
public class ResourceQuery {
    private static final Logger log = LoggerFactory.getLogger(ResourceQuery.class);
    private AccountingPersistenceQueryCouchBase accountingPersistenceQuery;
    private AccountingInitializer appManager = (AccountingInitializer)ApplicationManagerProvider.get(AccountingInitializer.class);

    @GET
    @Path(value="/getRecord/{recordId}/{type}/")
    public Response responseRecord(@NotNull @PathParam(value="recordId") String recordId, @NotNull @PathParam(value="type") String type) throws Exception {
        log.debug("call responseRecord with recordID:{}, type:{}", (Object)recordId, (Object)type);
        Object response = null;
        String result = null;
        try {
            this.accountingPersistenceQuery = this.appManager.getAccountingPersistenceQuery();
            result = this.accountingPersistenceQuery.getRecord(recordId, type);
            return Response.status((int)200).entity((Object)result).build();
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
            return Response.status((int)500).entity((Object)"").build();
        }
    }
}

