package org.gcube.data.publishing.ckan2zenodo.clients;

import java.util.Collection;
import java.util.concurrent.Callable;

import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.gcube.data.publishing.ckan2zenodo.model.UploadPolicy;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.FileDeposition;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.ZenodoDeposition;

public class UploadFilesCall implements Callable<ZenodoDeposition>{

	private UploadPolicy policy;
	private Collection<CkanResource> toUpload;
	private ZenodoDeposition deposition;
	private Zenodo z;
	
	
	
	public UploadFilesCall(UploadPolicy policy, Collection<CkanResource> toUpload, ZenodoDeposition deposition,
			Zenodo z) {
		super();
		this.policy = policy;
		this.toUpload = toUpload;
		this.deposition = deposition;
		this.z = z;
	}



	@Override
	public ZenodoDeposition call() throws Exception {
		ZenodoDeposition dep=deposition;
		
			if(policy.equals(UploadPolicy.DELETE_ALL)) {
				for(FileDeposition f:dep.getFiles()) {
					try{
						z.deleteFile(dep.getId(), f);
					}catch(Throwable t) {
						throw new Exception("Unable to delete "+f,t);
					}
				}
			}


			for(CkanResource r:toUpload) {
				try {
				switch(policy) {
				case SKIP_EXISTING : {
					boolean found=false;
					for(FileDeposition f:dep.getFiles()) {
						if(f.getFilename().equals(r.getName())) {
							found=true;
							break;
						}
					}						
					if(!found) z.uploadFile(dep, r.getName(), r.getUrl());
					break;
				}
				case DELETE_EXISTING : {
					for(FileDeposition f:dep.getFiles()) {
						if(f.getFilename().equals(r.getName())) {
							z.deleteFile(dep.getId(), f);
							break;
						}
					}
					// continue with default
				}
				default : {
					z.uploadFile(dep, r.getName(), r.getUrl());
				}

				}
			}catch(Throwable t) {
				throw new Exception("Unable to upload "+r.getName()+".",t); 
			}
			}
		return z.readDeposition(dep.getId());
	}
	
}
