package org.gcube.data.publishing.ckan2zenodo.clients;

import java.nio.file.Files;
import java.util.Collection;
import java.util.concurrent.Callable;

import org.gcube.data.publishing.ckan2zenodo.commons.Net;
import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.gcube.data.publishing.ckan2zenodo.model.DownloadedFile;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.FileDeposition;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.ZenodoDeposition;

import lombok.extern.slf4j.Slf4j;


@Slf4j
public class UploadFilesCall implements Callable<ZenodoDeposition>{

	private Collection<CkanResource> toUpload;
	private ZenodoDeposition deposition;
	private Zenodo z;



	public UploadFilesCall(Collection<CkanResource> toUpload, ZenodoDeposition deposition,
			Zenodo z) {
		super();
		this.toUpload = toUpload;
		this.deposition = deposition;
		this.z = z;
	}



	@Override
	public ZenodoDeposition call() throws Exception {
		ZenodoDeposition dep=deposition;

		log.debug("Starting file transfer for deposition "+deposition.getTitle()+" id : "+deposition.getId());

		log.debug("Removing not referenced files..");

		for(FileDeposition f:dep.getFiles()) {
			CkanResource found=null;
			for(CkanResource r:toUpload)
				if(r.getName().equals(f.getFilename())) {
					found=r;
					break;
				}
			if(found==null) // File not present in current toUpload set
				try{
					log.debug("Remote file "+f+" is not in requested set. Deleting it..");
					z.deleteFile(dep, f);
				}catch(Throwable t) {
					throw new Exception("Unable to delete "+f,t);
				}
			else {
					 // File present, checking for update
				DownloadedFile downloaded=null;
				try {
					log.debug("Found already existing remote file "+f);
					downloaded=Net.download(found);
					if(!downloaded.getMD5().equals(f.getChecksum())) {
						log.debug("MD5 differ, going to update : "+downloaded+" - "+f);
						z.deleteFile(dep, f);
						z.uploadFile(dep, found.getName(), downloaded.getF());
					}	
				}catch(Throwable t) {
					throw new Exception("Unable to update "+f,t);
				}finally {
					if(downloaded!=null) Files.deleteIfExists(downloaded.getF().toPath());
				}
			}
		}


		log.debug("Going to push additional resources for "+deposition.getTitle()+" ID : "+deposition.getId());				

		for(CkanResource r:toUpload) {
			DownloadedFile downloaded=null;
			try {
				boolean found=false;				

				for(FileDeposition f:dep.getFiles())
					if(f.getFilename().equals(r.getName())) {						
						found=true;													
						break;
					}
				if(!found) {
					downloaded=Net.download(r);
					z.uploadFile(dep, r.getName(),downloaded.getF());				
				}				
			}catch(Throwable t) {
				throw new Exception("Unable to upload "+r.getName()+".",t); 
			}
		}
		return z.readDeposition(dep.getId());
	}




}
