/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.model.parsing;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;

public class Mapping {
    @NonNull
    private Source source;
    @NonNull
    private String targetPath;
    @NonNull
    private TargetElement targetElement;
    @NonNull
    private HashMap<String, String> valueMapping;
    @NonNull
    private List<Regexp> regexp;

    @ConstructorProperties(value={"source", "targetPath", "targetElement", "valueMapping", "regexp"})
    public Mapping(@NonNull Source source, @NonNull String targetPath, @NonNull TargetElement targetElement, @NonNull HashMap<String, String> valueMapping, @NonNull List<Regexp> regexp) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (targetPath == null) {
            throw new NullPointerException("targetPath");
        }
        if (targetElement == null) {
            throw new NullPointerException("targetElement");
        }
        if (valueMapping == null) {
            throw new NullPointerException("valueMapping");
        }
        if (regexp == null) {
            throw new NullPointerException("regexp");
        }
        this.source = source;
        this.targetPath = targetPath;
        this.targetElement = targetElement;
        this.valueMapping = valueMapping;
        this.regexp = regexp;
    }

    @NonNull
    public Source getSource() {
        return this.source;
    }

    @NonNull
    public String getTargetPath() {
        return this.targetPath;
    }

    @NonNull
    public TargetElement getTargetElement() {
        return this.targetElement;
    }

    @NonNull
    public HashMap<String, String> getValueMapping() {
        return this.valueMapping;
    }

    @NonNull
    public List<Regexp> getRegexp() {
        return this.regexp;
    }

    public String toString() {
        return "Mapping(source=" + this.getSource() + ", targetPath=" + this.getTargetPath() + ", targetElement=" + this.getTargetElement() + ", valueMapping=" + this.getValueMapping() + ", regexp=" + this.getRegexp() + ")";
    }

    public static class TargetElement {
        private Boolean append = false;
        @NonNull
        private String targetElement;

        public Boolean getAppend() {
            return this.append;
        }

        @NonNull
        public String getTargetElement() {
            return this.targetElement;
        }

        public String toString() {
            return "Mapping.TargetElement(append=" + this.getAppend() + ", targetElement=" + this.getTargetElement() + ")";
        }

        @ConstructorProperties(value={"targetElement"})
        public TargetElement(@NonNull String targetElement) {
            if (targetElement == null) {
                throw new NullPointerException("targetElement");
            }
            this.targetElement = targetElement;
        }

        public void setAppend(Boolean append) {
            this.append = append;
        }
    }

    public static class Source {
        private List<Value> values = new ArrayList<Value>();

        public List<Value> getValues() {
            return this.values;
        }

        public String toString() {
            return "Mapping.Source(values=" + this.getValues() + ")";
        }

        public static class Value {
            private String split;
            @NonNull
            private Type type;
            @NonNull
            private String value;

            @ConstructorProperties(value={"type", "value"})
            public Value(@NonNull Type type, @NonNull String value) {
                if (type == null) {
                    throw new NullPointerException("type");
                }
                if (value == null) {
                    throw new NullPointerException("value");
                }
                this.type = type;
                this.value = value;
            }

            public String getSplit() {
                return this.split;
            }

            @NonNull
            public Type getType() {
                return this.type;
            }

            @NonNull
            public String getValue() {
                return this.value;
            }

            public String toString() {
                return "Mapping.Source.Value(split=" + this.getSplit() + ", type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ")";
            }

            public void setSplit(String split) {
                this.split = split;
            }

            public static enum Type {
                jsonPath,
                constant;

            }
        }
    }

    public static class Regexp {
        @NonNull
        private Type type;
        @NonNull
        private String target;
        private String replacement;

        @ConstructorProperties(value={"type", "target"})
        public Regexp(@NonNull Type type, @NonNull String target) {
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (target == null) {
                throw new NullPointerException("target");
            }
            this.type = type;
            this.target = target;
        }

        @NonNull
        public Type getType() {
            return this.type;
        }

        @NonNull
        public String getTarget() {
            return this.target;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public String toString() {
            return "Mapping.Regexp(type=" + (Object)((Object)this.getType()) + ", target=" + this.getTarget() + ", replacement=" + this.getReplacement() + ")";
        }

        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public static enum Type {
            replace,
            extract;

        }
    }
}

