/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.gcube.data.publishing.ckan2zenodo.commons.Parsing;
import org.gcube.data.publishing.ckan2zenodo.model.CkanItemDescriptor;
import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.gcube.data.publishing.ckan2zenodo.model.faults.TransformationException;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.Filter;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.Mapping;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.Mappings;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.Regexp;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.ResourceFilter;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.TargetElement;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.Value;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.Contributor;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.Creator;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.DepositionMetadata;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.RelatedIdentifier;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.ZenodoDeposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Translator {
    private static final Logger log = LoggerFactory.getLogger(Translator.class);
    @NonNull
    private List<Mapping> mappings;
    @NonNull
    private ResourceFilter resourceFilter;

    public Translator() {
        this(Collections.EMPTY_LIST, ResourceFilter.PASS_ALL);
    }

    public Translator(List<Mapping> mappings) {
        this(mappings, ResourceFilter.PASS_ALL);
    }

    public Translator(Mappings m) {
        this(m.getMappings(), m.getResourceFilters());
    }

    public ZenodoDeposition transform(CkanItemDescriptor toTransform, ZenodoDeposition deposition) throws TransformationException {
        String maintainerName;
        DepositionMetadata meta;
        log.debug("Transforming " + toTransform + ". Existing Deposition is : " + deposition);
        if (deposition == null) {
            deposition = new ZenodoDeposition();
        }
        if ((meta = deposition.getMetadata()) == null) {
            meta = new DepositionMetadata();
        }
        meta.setUpload_type(DepositionMetadata.UploadType.other);
        meta.setTitle(toTransform.getTitle());
        meta.setDescription(toTransform.getNotes());
        if (toTransform.isOpen().booleanValue()) {
            meta.setAccess_right(DepositionMetadata.AccessRights.open);
        } else {
            meta.setAccess_right(DepositionMetadata.AccessRights.restricted);
            meta.setAccess_conditions("Visit the VRE " + toTransform.getVRE() + " to access it.");
        }
        meta.setLicense(toTransform.getLicenseId());
        meta.setKeywords(new ArrayList<String>(toTransform.getTags()));
        String itemUrl = toTransform.getItemUrl();
        ArrayList<RelatedIdentifier> relatedIdentifiers = new ArrayList<RelatedIdentifier>();
        if (itemUrl != null) {
            relatedIdentifiers.add(new RelatedIdentifier(itemUrl, RelatedIdentifier.Relation.isCompiledBy));
        }
        meta.setRelated_identifiers(relatedIdentifiers);
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        ArrayList<Creator> creators = new ArrayList<Creator>();
        String authorName = toTransform.getAuthor();
        if (authorName != null) {
            Contributor author = new Contributor(Contributor.Type.Producer);
            author.setName(authorName);
            contributors.add(author);
            creators.add(new Creator(authorName));
        }
        if ((maintainerName = toTransform.getAuthor()) != null) {
            Contributor maintainer = new Contributor(Contributor.Type.DataCurator);
            maintainer.setName(maintainerName);
            contributors.add(maintainer);
            creators.add(new Creator(authorName));
        }
        Contributor d4Science = new Contributor(Contributor.Type.HostingInstitution);
        d4Science.setName("D4Science");
        contributors.add(d4Science);
        meta.setContributors(contributors);
        meta.setCreators(creators);
        meta.setVersion(toTransform.getVersion());
        meta.setPublication_date(Date.from(Instant.now()));
        deposition.setMetadata(meta);
        return this.applyMappings(toTransform, deposition);
    }

    /*
     * WARNING - void declaration
     */
    private ZenodoDeposition applyMappings(CkanItemDescriptor source, ZenodoDeposition target) throws TransformationException {
        try {
            ObjectMapper mapper = Parsing.getMapper();
            DocumentContext sourceCtx = JsonPath.using((Configuration)Parsing.JSON_PATH_ALWAYS_LIST_CONFIG).parse(source.getContent());
            DocumentContext targetCtx = JsonPath.using((Configuration)Parsing.JSON_PATH_ALWAYS_LIST_CONFIG).parse(mapper.writeValueAsString((Object)target));
            for (Mapping mapping : this.mappings) {
                log.debug("Applying {}\u00a0", (Object)mapping);
                try {
                    Object targetElementFound;
                    ArrayList<String> sourceValues = new ArrayList<String>();
                    for (Value v : mapping.getSource().getValues()) {
                        ArrayList<String> actualValues = new ArrayList<String>();
                        switch (v.getType()) {
                            case constant: {
                                actualValues.add(v.getValue());
                                break;
                            }
                            case jsonPath: {
                                for (String string : (Collection)sourceCtx.read(v.getValue(), new Predicate[0])) {
                                    String string2;
                                    if (string == null || (string2 = string.trim()).isEmpty()) continue;
                                    actualValues.add(string2);
                                }
                                break;
                            }
                        }
                        for (String string : actualValues) {
                            if (v.getSplit() != null) {
                                for (String toAdd : string.split(v.getSplit())) {
                                    sourceValues.add(toAdd.trim());
                                }
                                continue;
                            }
                            sourceValues.add(string);
                        }
                        if (sourceValues.isEmpty()) continue;
                        break;
                    }
                    log.debug("Found matching " + sourceValues);
                    ArrayList resultingValueList = new ArrayList();
                    if (!(sourceValues.isEmpty() || (targetElementFound = (List)targetCtx.read(mapping.getTargetPath().getValue(), new Predicate[0])) != null && targetElementFound.size() != 0 && targetElementFound.get(0) != null && mapping.getTargetPath().getAppend().booleanValue())) {
                        JsonPath path = JsonPath.compile((String)mapping.getTargetPath().getValue(), (Predicate[])new Predicate[0]);
                        switch (mapping.getTargetPath().getType()) {
                            case array: {
                                targetCtx = targetCtx.set(path, (Object)new Object[sourceValues.size()]);
                                break;
                            }
                            case map: {
                                targetCtx = targetCtx.set(path, null);
                            }
                        }
                    }
                    targetElementFound = sourceValues.iterator();
                    while (targetElementFound.hasNext()) {
                        void var12_19;
                        String sourceValue;
                        String string = sourceValue = (String)targetElementFound.next();
                        log.debug("Managing " + string);
                        for (Regexp regexp : mapping.getRegexp()) {
                            switch (regexp.getType()) {
                                case extract: {
                                    Pattern p = Pattern.compile(regexp.getTarget());
                                    Matcher m = p.matcher((CharSequence)var12_19);
                                    if (m.find()) {
                                        String string3 = m.group();
                                        break;
                                    }
                                    Object var12_21 = null;
                                    break;
                                }
                                case replace: {
                                    if (var12_19 == null) break;
                                    String replacement = regexp.getReplacement() != null ? regexp.getReplacement() : "";
                                    String string4 = var12_19.replaceAll(regexp.getTarget(), replacement);
                                    break;
                                }
                            }
                        }
                        String string5 = mapping.getValueMapping().getOrDefault(sourceValue, (String)var12_19);
                        HashMap<String, void> hashMap = new HashMap<String, void>();
                        for (TargetElement el : mapping.getTargetElements()) {
                            void var12_24;
                            String original;
                            if (el.getConstant() != null) {
                                String string6 = el.getConstant();
                            } else if (el.getAppend().booleanValue() && (original = (String)((List)targetCtx.read(mapping.getTargetPath() + "." + el.getValue(), new Predicate[0])).get(0)) != null && !original.isEmpty()) {
                                String string7 = original + (String)var12_24;
                            }
                            hashMap.put(el.getValue(), var12_24);
                        }
                        resultingValueList.add(hashMap);
                    }
                    JsonPath path = JsonPath.compile((String)mapping.getTargetPath().getValue(), (Predicate[])new Predicate[0]);
                    switch (mapping.getTargetPath().getType()) {
                        case array: {
                            targetCtx.set(path, resultingValueList);
                            break;
                        }
                        case map: {
                            for (Map map : resultingValueList) {
                                log.debug("Applying " + map + " to " + mapping.getTargetPath());
                                targetCtx.set(path, (Object)map);
                            }
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    throw new TransformationException("Exception while applying " + mapping, t);
                }
            }
            String serializedOutput = targetCtx.jsonString();
            log.debug("Mapping complete. Going to return : " + serializedOutput);
            return (ZenodoDeposition)mapper.readValue(serializedOutput, ZenodoDeposition.class);
        }
        catch (Throwable t) {
            log.error("Unable to translate " + source + " using previous " + target, t);
            throw new TransformationException("Unable to translate " + source.getName(), t);
        }
    }

    public List<CkanResource> filterResources(CkanItemDescriptor source) throws TransformationException {
        ObjectMapper mapper = Parsing.getMapper();
        DocumentContext sourceCtx = JsonPath.using((Configuration)Parsing.JSON_PATH_ALWAYS_LIST_CONFIG).parse(source.getContent());
        try {
            HashSet<Object> toReturn = new HashSet<Object>();
            for (Filter f : this.resourceFilter.getFilters()) {
                JSONArray filtered = (JSONArray)sourceCtx.read(f.getConditions().get(0), new Predicate[0]);
                for (Object obj : filtered) {
                    Map map = (Map)obj;
                    toReturn.add(mapper.readValue(new JSONObject(map).toJSONString(), CkanResource.class));
                }
            }
            return new ArrayList<CkanResource>(toReturn);
        }
        catch (Throwable t) {
            log.error("Unable to filter resources. ", t);
            throw new TransformationException("Unable to filter " + source.getName() + " resources", t);
        }
    }

    @ConstructorProperties(value={"mappings", "resourceFilter"})
    public Translator(@NonNull List<Mapping> mappings, @NonNull ResourceFilter resourceFilter) {
        if (mappings == null) {
            throw new NullPointerException("mappings");
        }
        if (resourceFilter == null) {
            throw new NullPointerException("resourceFilter");
        }
        this.mappings = mappings;
        this.resourceFilter = resourceFilter;
    }
}

