/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.model;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadedFile {
    private static final Logger log = LoggerFactory.getLogger(DownloadedFile.class);
    private static final Pattern FILENAME_IN_DEPOSITION_REGEXP = Pattern.compile("(?<=filename\\=\\\").*(?=\\\")");
    @NonNull
    private CkanResource source;
    private File f = null;
    private String MD5 = null;
    private String remoteFileName = null;

    public String toString() {
        return "DownloadedFile{source=" + this.source + ", f=" + this.f + ", MD5='" + this.MD5 + '\'' + ", remoteFileName='" + this.remoteFileName + '\'' + '}';
    }

    public String getToUseFileName() throws Exception {
        String evaluatedExtension;
        if (DownloadedFile.getExtension(this.source.getName()) != null) {
            return this.source.getName();
        }
        if (this.remoteFileName == null) {
            this.initRemoteFileName();
        }
        if ((evaluatedExtension = DownloadedFile.getExtension(this.remoteFileName)) != null) {
            return this.source.getName() + evaluatedExtension;
        }
        return this.source.getName();
    }

    public File getFile() throws Exception {
        if (this.f == null) {
            this.download();
        }
        return this.f;
    }

    public String getMD5() throws Exception {
        if (this.MD5 == null) {
            this.download();
        }
        return this.MD5;
    }

    static final String getExtension(String filename) {
        int lastIndexOf = filename.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return null;
        }
        return filename.substring(lastIndexOf);
    }

    private void download() throws Exception {
        log.info("Downloading {} from {}", (Object)this.source.getName(), (Object)this.source.getUrl());
        URL url = new URL(this.source.getUrl());
        this.f = File.createTempFile("zenodo_", ".tmp");
        MessageDigest md = MessageDigest.getInstance("MD5");
        InputStream is = null;
        int attempt = 0;
        Exception lastException = null;
        while (is == null && attempt < 5) {
            try {
                ++attempt;
                is = url.openStream();
                if (this.remoteFileName != null) continue;
                this.remoteFileName = DownloadedFile.getFilenameFromURL(url);
            }
            catch (Exception e) {
                lastException = e;
                try {
                    Thread.sleep(500 * attempt);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (is == null) {
            throw new Exception("Unable to download " + this.source.getUrl(), lastException);
        }
        if (this.remoteFileName == null) {
            this.remoteFileName = "";
        }
        DigestInputStream dis = new DigestInputStream(is, md);
        this.MD5 = dis.getMessageDigest().toString();
        long size = Files.copy(is, this.f.toPath(), StandardCopyOption.REPLACE_EXISTING);
        log.info("Received {} bytes for {} ", (Object)size, (Object)this.source.getName());
    }

    private void initRemoteFileName() throws Exception {
        int attempt = 0;
        Exception lastException = null;
        URL url = new URL(this.source.getUrl());
        while (this.remoteFileName == null && attempt < 5) {
            try {
                ++attempt;
                this.remoteFileName = DownloadedFile.getFilenameFromURL(url);
            }
            catch (Exception e) {
                lastException = e;
                try {
                    Thread.sleep(500 * attempt);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.remoteFileName == null) {
            this.remoteFileName = "";
            log.warn("Unable to get remote file name from {} [resource Name {}]", new Object[]{this.source.getUrl(), this.source.getName(), lastException});
        }
    }

    private static final String getFilenameFromURL(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        String contentDisp = con.getHeaderField("Content-Disposition");
        Matcher m = FILENAME_IN_DEPOSITION_REGEXP.matcher(contentDisp);
        m.find();
        return m.group(0);
    }

    @ConstructorProperties(value={"source"})
    public DownloadedFile(@NonNull CkanResource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.source = source;
    }

    @NonNull
    public CkanResource getSource() {
        return this.source;
    }
}

