package org.gcube.data.publishing.gis.geoserver.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Table {
	private long rowCount;
	private String tableName;
	private Map<String,SQLType> fields=new HashMap<String,SQLType>();
	private ArrayList<String> insertQueryFields=new ArrayList<String>();
	
	
	public Table() {
		// TODO Auto-generated constructor stub
	}

	
	public Table(long rowCount, String tableName, Map<String, SQLType> fields,
			ArrayList<String> insertQueryFields) {
		super();
		this.rowCount = rowCount;
		this.tableName = tableName;
		this.fields = fields;
		this.insertQueryFields = insertQueryFields;
	}

	/**
	 * @return the rowCount
	 */
	public long getRowCount() {
		return rowCount;
	}


	/**
	 * @param rowCount the rowCount to set
	 */
	public void setRowCount(long rowCount) {
		this.rowCount = rowCount;
	}


	/**
	 * @return the tableName
	 */
	public String getTableName() {
		return tableName;
	}


	/**
	 * @param tableName the tableName to set
	 */
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}


	/**
	 * @return the fields
	 */
	public Map<String, SQLType> getFields() {
		return fields;
	}


	/**
	 * @param fields the fields to set
	 */
	public void setFields(Map<String, SQLType> fields) {
		this.fields = fields;
	}


	/**
	 * @return the insertQueryFields
	 */
	public ArrayList<String> getInsertQueryFields() {
		return insertQueryFields;
	}


	/**
	 * @param insertQueryFields the insertQueryFields to set
	 */
	public void setInsertQueryFields(ArrayList<String> insertQueryFields) {
		this.insertQueryFields = insertQueryFields;
	}


	public void addField(String name,SQLType type, boolean inQuery){
		this.fields.put(name, type);
		if(inQuery)this.insertQueryFields.add(name);
	}
	
	public void setField(String name,SQLType type, boolean inQuery,int index){
		this.fields.put(name, type);
		if(inQuery)this.insertQueryFields.add(index,name);
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Table [rowCount=");
		builder.append(rowCount);
		builder.append(", tableName=");
		builder.append(tableName);
		builder.append(", fields=");
		builder.append(fields);
		builder.append(", insertQueryFields=");
		builder.append(insertQueryFields);
		builder.append("]");
		return builder.toString();
	}


	
	
	
}
