/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.geoserver.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.publishing.gis.geoserver.Utils;
import org.gcube.data.publishing.gis.geoserver.db.SQLType;
import org.gcube.data.publishing.gis.geoserver.db.Table;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GeometryPoint;
import org.postgis.PGgeometry;
import org.postgresql.PGConnection;

public class DBUtils {
    private static final GCUBELog logger = new GCUBELog(DBUtils.class);
    private static final String GEOM_FIELD = "the_geom";
    private static final String GID_FIELD = "gid";

    public static Connection getConnection(String endpoint, String user, String password) throws SQLException, ClassNotFoundException {
        Connection toReturn = DriverManager.getConnection(endpoint, user, password);
        toReturn.setAutoCommit(false);
        ((PGConnection)toReturn).addDataType("geometry", Class.forName("org.postgis.PGgeometry"));
        return toReturn;
    }

    public static PreparedStatement prepareStatementForInsert(Connection conn, Table theTable, GeometryPoint point) throws SQLException {
        StringBuilder fieldsName = new StringBuilder("(the_geom,");
        StringBuilder fieldsValues = new StringBuilder("(?,");
        for (String f : point.getAttributes().keySet()) {
            if (f.equalsIgnoreCase(GEOM_FIELD) || f.equalsIgnoreCase(GID_FIELD)) continue;
            fieldsValues.append("?,");
            fieldsName.append(f + ",");
        }
        fieldsValues.deleteCharAt(fieldsValues.length() - 1);
        fieldsValues.append(")");
        fieldsName.deleteCharAt(fieldsName.length() - 1);
        fieldsName.append(")");
        String query = "INSERT INTO " + theTable.getTableName() + " " + fieldsName + " VALUES " + fieldsValues;
        logger.debug((Object)("the prepared statement is :" + query));
        PreparedStatement ps = conn.prepareStatement(query, 2);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table createTable(Connection conn, GeometryPoint point) throws SQLException {
        Table toReturn = new Table();
        toReturn.setTableName("t" + Utils.getUUID());
        StringBuilder createQuery = new StringBuilder("CREATE TABLE " + toReturn.getTableName() + " ( " + GID_FIELD + " " + DBUtils.getTypeDefinition(SQLType.SERIAL) + " NOT NULL,");
        createQuery.append("the_geom " + DBUtils.getTypeDefinition(SQLType.GEOMETRY) + ",");
        toReturn.addField(GID_FIELD, SQLType.SERIAL, false);
        toReturn.addField(GEOM_FIELD, SQLType.GEOMETRY, true);
        for (Map.Entry field : point.getAttributes().entrySet()) {
            if (((String)field.getKey()).equalsIgnoreCase(GID_FIELD) || ((String)field.getKey()).equalsIgnoreCase(GEOM_FIELD)) continue;
            SQLType type = DBUtils.getSQLType(field.getValue());
            createQuery.append(" " + (String)field.getKey() + " " + DBUtils.getTypeDefinition(type) + ",");
            toReturn.addField((String)field.getKey(), type, true);
        }
        createQuery.deleteCharAt(createQuery.lastIndexOf(","));
        createQuery.append(")");
        String query = createQuery.toString();
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            logger.debug((Object)("Goin to execute " + query));
            stmt.execute(query);
            Table table = toReturn;
            return table;
        }
    }

    public static int insertPoint(Table theTable, PreparedStatement ps, GeometryPoint point) throws SQLException {
        block10: for (int index = 1; index <= theTable.getInsertQueryFields().size(); ++index) {
            String fieldName = theTable.getInsertQueryFields().get(index - 1);
            SQLType type = theTable.getFields().get(fieldName);
            if (fieldName.equals(GEOM_FIELD)) {
                ps.setObject(index, point.getTheGeometry());
                continue;
            }
            if (fieldName.equalsIgnoreCase(GID_FIELD)) continue;
            Object value = point.getAttributes().get(fieldName);
            if (value == null) {
                ps.setNull(index, DBUtils.getType(type));
            }
            switch (type) {
                case BOOLEAN: {
                    ps.setBoolean(index, (Boolean)value);
                    continue block10;
                }
                case DATE: {
                    ps.setDate(index, (Date)value);
                    continue block10;
                }
                case FLOAT: {
                    ps.setFloat(index, ((Float)value).floatValue());
                    continue block10;
                }
                case GEOMETRY: {
                    ps.setObject(index, value);
                    continue block10;
                }
                case INTEGER: {
                    ps.setInt(index, (Integer)value);
                    continue block10;
                }
                case LONG: {
                    ps.setLong(index, (Long)value);
                    continue block10;
                }
                case TIME: {
                    ps.setTime(index, (Time)value);
                    continue block10;
                }
                case TIMESTAMP: {
                    ps.setTimestamp(index, (Timestamp)value);
                    continue block10;
                }
                default: {
                    ps.setString(index, value.toString());
                }
            }
        }
        return ps.executeUpdate();
    }

    private static SQLType getSQLType(Object obj) {
        if (obj.getClass().isAssignableFrom(Integer.class)) {
            return SQLType.INTEGER;
        }
        if (obj.getClass().isAssignableFrom(Long.class)) {
            return SQLType.LONG;
        }
        if (obj.getClass().isAssignableFrom(Float.class)) {
            return SQLType.INTEGER;
        }
        if (obj.getClass().isAssignableFrom(Date.class) || obj.getClass().isAssignableFrom(java.util.Date.class)) {
            return SQLType.DATE;
        }
        if (obj.getClass().isAssignableFrom(Time.class)) {
            return SQLType.TIME;
        }
        if (obj.getClass().isAssignableFrom(Timestamp.class)) {
            return SQLType.TIMESTAMP;
        }
        if (obj.getClass().isAssignableFrom(Boolean.class)) {
            return SQLType.BOOLEAN;
        }
        if (obj.getClass().isAssignableFrom(PGgeometry.class)) {
            return SQLType.GEOMETRY;
        }
        return SQLType.TEXT;
    }

    private static int getType(SQLType type) {
        switch (type) {
            case BOOLEAN: {
                return 16;
            }
            case DATE: {
                return 91;
            }
            case FLOAT: {
                return 3;
            }
            case GEOMETRY: {
                return 1111;
            }
            case INTEGER: {
                return 4;
            }
            case LONG: {
                return -5;
            }
            case STRING: {
                return 12;
            }
            case TEXT: {
                return -16;
            }
            case TIME: {
                return 92;
            }
            case TIMESTAMP: {
                return 93;
            }
            case SERIAL: {
                return -5;
            }
        }
        return 0;
    }

    private static String getTypeDefinition(SQLType type) {
        switch (type) {
            case BOOLEAN: {
                return "boolean";
            }
            case DATE: {
                return "date";
            }
            case FLOAT: {
                return "decimal";
            }
            case GEOMETRY: {
                return "geometry";
            }
            case INTEGER: {
                return "integer";
            }
            case LONG: {
                return "bigint";
            }
            case STRING: {
                return "varchar (200)";
            }
            case TEXT: {
                return "text";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case SERIAL: {
                return "serial";
            }
        }
        return "";
    }
}

