/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.geoserver;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.data.publishing.gis.geoserver.Constants;
import org.gcube.data.publishing.gis.geoserver.GeoServerPlugin;
import org.gcube.data.publishing.gis.geoserver.model.DBDescriptor;
import org.gcube.data.publishing.gis.geoserver.model.DataSourceDescriptor;
import org.gcube.data.publishing.gis.geoserver.model.GeoServerDescriptor;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.CSquareConverter;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.GISInteraction;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.GISInteractionFactory;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISDataType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISFileType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISRepositoryType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISStreamedType;

public class GeoServerInteractionFactory
implements GISInteractionFactory {
    private static GCUBELog logger = new GCUBELog(GeoServerInteractionFactory.class);
    protected static ISClient isClient;
    private static final List<GISDataType> supportedTypes;
    private List<DBDescriptor> databases = new ArrayList<DBDescriptor>();
    private List<GeoServerDescriptor> geoservers = new ArrayList<GeoServerDescriptor>();
    private List<DataSourceDescriptor> geonetworks = new ArrayList<DataSourceDescriptor>();
    private GCUBEScope scope;

    public boolean init(GCUBEScope scope) {
        this.scope = scope;
        try {
            this.databases = GeoServerInteractionFactory.getGISDataBase(scope);
            this.geoservers = GeoServerInteractionFactory.getGeoServers(scope);
            this.geonetworks = GeoServerInteractionFactory.getGeoNetwork(scope);
            if (this.databases.size() == 0) {
                throw new Exception("No Gis DataBase found in scope");
            }
            if (this.geoservers.size() == 0) {
                throw new Exception("No GeoServer found in scope");
            }
            if (this.geonetworks.size() == 0) {
                throw new Exception("No Geonetwork found in scope");
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Unable to gather informations under scope " + scope), (Throwable)e);
            return false;
        }
    }

    public GISInteraction createInteraction(CSquareConverter converter) throws Exception {
        DataSourceDescriptor geoNetwork = this.geonetworks.get(0);
        GeoServerDescriptor geoServer = this.geoservers.get(0);
        GeoCaller caller = new GeoCaller(geoNetwork.getEntryPoint(), geoNetwork.getUser(), geoNetwork.getPassword(), geoServer.getEntryPoint(), geoServer.getUser(), geoServer.getPassword(), GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD);
        return new GeoServerPlugin(converter, caller, this.databases.get(0), geoServer);
    }

    public void close() {
    }

    public GISRepositoryType getHandledRepositoryType() {
        return GISRepositoryType.GEOSERVER;
    }

    public List<GISDataType> getHandledDataType() {
        return supportedTypes;
    }

    protected static List<GeoServerDescriptor> getGeoServers(GCUBEScope scope) throws Exception {
        logger.debug((Object)"Checking geoServers..");
        ArrayList<GeoServerDescriptor> toReturn = new ArrayList<GeoServerDescriptor>();
        GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", Constants.get().getGeoServerCategoryName())});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", Constants.get().getGeoServerPlatformName())});
        List list = isClient.execute((ISQuery)runtimeQuery, scope);
        for (GCUBERuntimeResource rr : list) {
            try {
                for (AccessPoint access : rr.getAccessPoints()) {
                    if (!access.getEntryname().equals(Constants.get().getGeoServerEntryName())) continue;
                    logger.debug((Object)("Found Access point " + access.getEntryname() + " in " + rr.getName() + " [ ID : " + rr.getID() + "]"));
                    toReturn.add(new GeoServerDescriptor(access.getEndpoint(), access.getUsername(), access.getPassword(), access.getProperty(Constants.get().getGeoServerAquaMapsWorkspace()), access.getProperty(Constants.get().getGeoServerAquaMapsDataStore()), access.getProperty(Constants.get().getGeoServerAquaMapsDefaultDistributionStyle())));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to parse resource [ID :" + rr.getID() + "]"), (Throwable)e);
            }
        }
        return toReturn;
    }

    protected static List<DataSourceDescriptor> getGeoNetwork(GCUBEScope scope) throws Exception {
        logger.debug((Object)"Checking geoNetwork..");
        ArrayList<DataSourceDescriptor> toReturn = new ArrayList<DataSourceDescriptor>();
        GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", Constants.get().getGeoNetworkCategoryName())});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", Constants.get().getGeoNetworkPlatformName())});
        List list = isClient.execute((ISQuery)runtimeQuery, scope);
        for (GCUBERuntimeResource rr : list) {
            try {
                for (AccessPoint access : rr.getAccessPoints()) {
                    if (!access.getEntryname().equals(Constants.get().getGeoNetworkEntryName())) continue;
                    logger.debug((Object)("Found Access point " + access.getEntryname() + " in " + rr.getName() + " [ ID : " + rr.getID() + "]"));
                    toReturn.add(new DataSourceDescriptor(access.getEndpoint(), access.getUsername(), access.getPassword()));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to parse resource [ID :" + rr.getID() + "]"), (Throwable)e);
            }
        }
        return toReturn;
    }

    protected static ArrayList<DBDescriptor> getGISDataBase(GCUBEScope scope) throws Exception {
        logger.debug((Object)"Checking gis DBs");
        ArrayList<DBDescriptor> toReturn = new ArrayList<DBDescriptor>();
        GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", Constants.get().getGeoServerDBCategory())});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", Constants.get().getGeoServerDBPlatformName())});
        List list = isClient.execute((ISQuery)runtimeQuery, scope);
        for (GCUBERuntimeResource rr : list) {
            try {
                for (AccessPoint access : rr.getAccessPoints()) {
                    if (!access.getEntryname().equals(Constants.get().getGeoServerDBEntryName()) || !access.getAllPropertyNames().contains(Constants.get().getGeoServerDBAquaMapsDataStore()) || !Boolean.parseBoolean(access.getProperty(Constants.get().getGeoServerDBAquaMapsDataStore()))) continue;
                    logger.debug((Object)("Found Access point " + access.getEntryname() + " in " + rr.getName() + " [ ID : " + rr.getID() + "]"));
                    DBDescriptor toAdd = new DBDescriptor("jdbc:postgresql:" + access.getEndpoint(), access.getUsername(), access.getPassword(), DBDescriptor.DBType.postgres, Integer.parseInt(access.getProperty(Constants.get().getDBMaxConnection())));
                    toReturn.add(toAdd);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to parse resource [ID :" + rr.getID() + "]"), (Throwable)e);
            }
        }
        return toReturn;
    }

    static {
        supportedTypes = new ArrayList<GISDataType>();
        supportedTypes.add((GISDataType)GISStreamedType.COORDINATE_POINTS);
        supportedTypes.add((GISDataType)GISStreamedType.CSQUARE_POINTS);
        supportedTypes.add((GISDataType)GISStreamedType.GEOMETRIES);
        supportedTypes.add((GISDataType)GISFileType.GEOTIFF);
        supportedTypes.add((GISDataType)GISFileType.NETCDF);
        try {
            isClient = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to get ISClient implementation", (Throwable)e);
        }
    }
}

