/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.publisher.client.proxies;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.MapItemType;
import org.gcube.common.core.types.StringMap;
import org.gcube.common.core.types.VOID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.gis.publisher.stubs.DestinationTypeNotSupportedFault;
import org.gcube.data.gis.publisher.stubs.DestinationUnreachableFault;
import org.gcube.data.gis.publisher.stubs.GISType;
import org.gcube.data.gis.publisher.stubs.IncorrectDataTypeFault;
import org.gcube.data.gis.publisher.stubs.PublishDataRequestType;
import org.gcube.data.gis.publisher.stubs.PublisherPortType;
import org.gcube.data.publishing.gis.publisher.client.proxies.Publisher;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GISData;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GISFile;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.StreamedGISData;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.DataParsingException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.NotSupportedDataTypeException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.RepositoryTypeNotSupportedException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.UnreachableDestinationException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.requests.GISRequestConfiguration;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.response.PublishingReport;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.response.PublishingStatus;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISDataType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISFileType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISRepositoryType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISStreamedType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.utils.GISXstream;
import org.gcube.data.publishing.gis.publisher.stubs.utils.RSWrapper;

public class DefaultPublisher
implements Publisher {
    private final ProxyDelegate<PublisherPortType> delegate;
    private final XStream xstream = GISXstream.get();

    public DefaultPublisher(ProxyDelegate<PublisherPortType> delegate) {
        this.delegate = delegate;
    }

    @Override
    public PublishingReport publishData(GISData toPublish, GISRequestConfiguration config) throws DataParsingException, NotSupportedDataTypeException, UnreachableDestinationException, RepositoryTypeNotSupportedException, Exception {
        final UUID id = this.submitPublication(toPublish, config);
        Call<PublisherPortType, PublishingReport> call = new Call<PublisherPortType, PublishingReport>(){

            public PublishingReport call(PublisherPortType endpoint) throws Exception {
                return (PublishingReport)DefaultPublisher.this.xstream.fromXML(endpoint.getPublishingReport(id.toString()));
            }
        };
        PublishingReport toReturn = null;
        do {
            Thread.sleep(1000L);
        } while ((toReturn = (PublishingReport)this.delegate.make((Call)call)).getStatus().equals((Object)PublishingStatus.STARTED));
        return toReturn;
    }

    @Override
    public Map<GISRepositoryType, List<GISDataType>> getCapabilities() throws RemoteException, Exception {
        EnumMap<GISRepositoryType, List<GISDataType>> toReturn = new EnumMap<GISRepositoryType, List<GISDataType>>(GISRepositoryType.class);
        Call<PublisherPortType, StringMap> call = new Call<PublisherPortType, StringMap>(){

            public StringMap call(PublisherPortType endpoint) throws Exception {
                return endpoint.getCapabilities(new VOID());
            }
        };
        StringMap map = (StringMap)this.delegate.make((Call)call);
        if (map != null && map.getItems() != null) {
            for (MapItemType item : map.getItems()) {
                GISFileType dataType;
                GISRepositoryType itemRepo = GISRepositoryType.valueOf((String)item.getKey());
                if (!toReturn.containsKey(itemRepo)) {
                    toReturn.put(itemRepo, new ArrayList());
                }
                try {
                    dataType = GISFileType.valueOf((String)item.getValue());
                }
                catch (Exception e) {
                    dataType = GISStreamedType.valueOf((String)item.getValue());
                }
                ((List)toReturn.get(itemRepo)).add(dataType);
            }
        }
        return toReturn;
    }

    private UUID submitPublication(GISData toPublish, GISRequestConfiguration config) throws DataParsingException, NotSupportedDataTypeException, UnreachableDestinationException, RepositoryTypeNotSupportedException, Exception {
        StreamedGISData data;
        final PublishDataRequestType request = new PublishDataRequestType();
        request.setSerializedConfiguration(this.xstream.toXML((Object)config));
        GISType toSetType = null;
        String uri = null;
        if (toPublish.getClass().isAssignableFrom(StreamedGISData.class)) {
            data = (StreamedGISData)toPublish;
            switch (data.getType()) {
                case COORDINATE_POINTS: {
                    toSetType = GISType.COORD_STREAM;
                    break;
                }
                case CSQUARE_POINTS: {
                    toSetType = GISType.CSQUARE_STREAM;
                }
            }
            uri = data.getURI();
        } else if (toPublish.getClass().isAssignableFrom(GISFile.class)) {
            data = (GISFile)toPublish;
            if (!data.getFile().exists() || !data.getFile().canRead()) {
                throw new FileNotFoundException();
            }
            switch (data.getType()) {
                case GEOTIFF: {
                    toSetType = GISType.GEOTIFF;
                    break;
                }
                case NETCDF: {
                    toSetType = GISType.NETCDF;
                }
            }
            RSWrapper wrapper = new RSWrapper(GCUBEScope.getScope((String)ScopeProvider.instance.get()));
            File tmpCopy = File.createTempFile("tmp", ".tmp");
            FileUtils.copyFile((File)data.getFile(), (File)tmpCopy);
            wrapper.add(tmpCopy);
            wrapper.close();
            uri = wrapper.getLocator().toString();
        }
        request.setDataType(toSetType);
        request.setDataLocator(uri);
        Call<PublisherPortType, UUID> call = new Call<PublisherPortType, UUID>(){

            public UUID call(PublisherPortType publisherPT) throws Exception {
                try {
                    return UUID.fromString(publisherPT.publishData(request));
                }
                catch (DestinationUnreachableFault e) {
                    throw new UnreachableDestinationException((Throwable)e);
                }
                catch (IncorrectDataTypeFault e) {
                    throw new DataParsingException((Throwable)e);
                }
                catch (DestinationTypeNotSupportedFault e) {
                    throw new RepositoryTypeNotSupportedException((Throwable)e);
                }
            }
        };
        return (UUID)this.delegate.make((Call)call);
    }
}

