package org.gcube.data.publishing.gis.publisher.model.requests;

import java.awt.Color;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

@XStreamAlias("StyleGenerationRequest")
public class StyleGenerationRequest {

	@XStreamAlias("ClusterScaleType")
	public static enum ClusterScaleType{
		linear,logarithmic
	}
	
	@XStreamAsAttribute
	private String nameStyle; 
	@XStreamAsAttribute
	private  ClusterScaleType clusterScaleType;  
	private  String attributeName; 
	private  int nClasses; 
	private  Color c1; 
	private  Color c2; 
	private  Class typeValue;
	
	private  String max;
	private  String min;
	
	public StyleGenerationRequest() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @return the nameStyle
	 */
	public String getNameStyle() {
		return nameStyle;
	}

	/**
	 * @param nameStyle the nameStyle to set
	 */
	public void setNameStyle(String nameStyle) {
		this.nameStyle = nameStyle;
	}

	/**
	 * @return the attributeName
	 */
	public String getAttributeName() {
		return attributeName;
	}

	/**
	 * @param attributeName the attributeName to set
	 */
	public void setAttributeName(String attributeName) {
		this.attributeName = attributeName;
	}

	/**
	 * @return the nClasses
	 */
	public int getnClasses() {
		return nClasses;
	}

	/**
	 * @param nClasses the nClasses to set
	 */
	public void setnClasses(int nClasses) {
		this.nClasses = nClasses;
	}

	/**
	 * @return the c1
	 */
	public Color getC1() {
		return c1;
	}

	/**
	 * @param c1 the c1 to set
	 */
	public void setC1(Color c1) {
		this.c1 = c1;
	}

	/**
	 * @return the c2
	 */
	public Color getC2() {
		return c2;
	}

	/**
	 * @param c2 the c2 to set
	 */
	public void setC2(Color c2) {
		this.c2 = c2;
	}

	/**
	 * @return the typeValue
	 */
	public Class getTypeValue() {
		return typeValue;
	}

	/**
	 * @param typeValue the typeValue to set
	 */
	public void setTypeValue(Class typeValue) {
		this.typeValue = typeValue;
	}

	/**
	 * @return the max
	 */
	public String getMax() {
		return max;
	}

	/**
	 * @param max the max to set
	 */
	public void setMax(String max) {
		this.max = max;
	}

	/**
	 * @return the min
	 */
	public String getMin() {
		return min;
	}

	/**
	 * @param min the min to set
	 */
	public void setMin(String min) {
		this.min = min;
	}

	/**
	 * @return the clusterScaleType
	 */
	public ClusterScaleType getClusterScaleType() {
		return clusterScaleType;
	}

	/**
	 * @param clusterScaleType the clusterScaleType to set
	 */
	public void setClusterScaleType(ClusterScaleType clusterScaleType) {
		this.clusterScaleType = clusterScaleType;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((attributeName == null) ? 0 : attributeName.hashCode());
		result = prime * result + ((c1 == null) ? 0 : c1.hashCode());
		result = prime * result + ((c2 == null) ? 0 : c2.hashCode());
		result = prime
				* result
				+ ((clusterScaleType == null) ? 0 : clusterScaleType.hashCode());
		result = prime * result + ((max == null) ? 0 : max.hashCode());
		result = prime * result + ((min == null) ? 0 : min.hashCode());
		result = prime * result + nClasses;
		result = prime * result
				+ ((nameStyle == null) ? 0 : nameStyle.hashCode());
		result = prime * result
				+ ((typeValue == null) ? 0 : typeValue.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		StyleGenerationRequest other = (StyleGenerationRequest) obj;
		if (attributeName == null) {
			if (other.attributeName != null)
				return false;
		} else if (!attributeName.equals(other.attributeName))
			return false;
		if (c1 == null) {
			if (other.c1 != null)
				return false;
		} else if (!c1.equals(other.c1))
			return false;
		if (c2 == null) {
			if (other.c2 != null)
				return false;
		} else if (!c2.equals(other.c2))
			return false;
		if (clusterScaleType != other.clusterScaleType)
			return false;
		if (max == null) {
			if (other.max != null)
				return false;
		} else if (!max.equals(other.max))
			return false;
		if (min == null) {
			if (other.min != null)
				return false;
		} else if (!min.equals(other.min))
			return false;
		if (nClasses != other.nClasses)
			return false;
		if (nameStyle == null) {
			if (other.nameStyle != null)
				return false;
		} else if (!nameStyle.equals(other.nameStyle))
			return false;
		if (typeValue == null) {
			if (other.typeValue != null)
				return false;
		} else if (!typeValue.equals(other.typeValue))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("StyleGenerationRequest [nameStyle=");
		builder.append(nameStyle);
		builder.append(", attributeName=");
		builder.append(attributeName);
		builder.append(", nClasses=");
		builder.append(nClasses);
		builder.append(", c1=");
		builder.append(c1);
		builder.append(", c2=");
		builder.append(c2);
		builder.append(", typeValue=");
		builder.append(typeValue);
		builder.append(", max=");
		builder.append(max);
		builder.append(", min=");
		builder.append(min);
		builder.append(", clusterScaleType=");
		builder.append(clusterScaleType);
		builder.append("]");
		return builder.toString();
	}
	
	
	
}
