package org.gcube.data.publishing.gis.publisher.model.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;

@XStreamAlias("LayerGenerationRequest")
public class LayerGenerationRequest {

	@XStreamAsAttribute
	private String featureLabel;
	@XStreamAsAttribute
	private Class featureClass;
	@XStreamAsAttribute
	private String title;
	
	@XStreamAsAttribute
	private String name;
	
	@XStreamImplicit(itemFieldName="style")
	private ArrayList<String> toAssociateStyles=new ArrayList<String>();
	private int defaultStyleIndex=0;
	
	private Map<String,String> metaData=new HashMap<String, String>();
	
	
	public LayerGenerationRequest() {
		// TODO Auto-generated constructor stub
	}


	public LayerGenerationRequest(String featureLabel, Class featureClass,
			String title, String name, ArrayList<String> toAssociateStyles,
			int defaultStyleIndex, Map<String, String> metaData) {
		super();
		this.featureLabel = featureLabel;
		this.featureClass = featureClass;
		this.title = title;
		this.name = name;
		this.toAssociateStyles = toAssociateStyles;
		this.defaultStyleIndex = defaultStyleIndex;
		this.metaData = metaData;
	}


	/**
	 * @return the featureLabel
	 */
	public String getFeatureLabel() {
		return featureLabel;
	}


	/**
	 * @param featureLabel the featureLabel to set
	 */
	public void setFeatureLabel(String featureLabel) {
		this.featureLabel = featureLabel;
	}


	/**
	 * @return the featureClass
	 */
	public Class getFeatureClass() {
		return featureClass;
	}


	/**
	 * @param featureClass the featureClass to set
	 */
	public void setFeatureClass(Class featureClass) {
		this.featureClass = featureClass;
	}


	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}


	/**
	 * @param title the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}


	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}


	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}


	/**
	 * @return the toAssociateStyles
	 */
	public ArrayList<String> getToAssociateStyles() {
		return toAssociateStyles;
	}


	/**
	 * @param toAssociateStyles the toAssociateStyles to set
	 */
	public void setToAssociateStyles(ArrayList<String> toAssociateStyles) {
		this.toAssociateStyles = toAssociateStyles;
	}


	/**
	 * @return the defaultStyleIndex
	 */
	public int getDefaultStyleIndex() {
		return defaultStyleIndex;
	}


	/**
	 * @param defaultStyleIndex the defaultStyleIndex to set
	 */
	public void setDefaultStyleIndex(int defaultStyleIndex) {
		this.defaultStyleIndex = defaultStyleIndex;
	}


	/**
	 * @return the metaData
	 */
	public Map<String, String> getMetaData() {
		return metaData;
	}


	/**
	 * @param metaData the metaData to set
	 */
	public void setMetaData(Map<String, String> metaData) {
		this.metaData = metaData;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("LayerGenerationRequest [featureLabel=");
		builder.append(featureLabel);
		builder.append(", featureClass=");
		builder.append(featureClass);
		builder.append(", title=");
		builder.append(title);
		builder.append(", name=");
		builder.append(name);
		builder.append(", toAssociateStyles=");
		builder.append(toAssociateStyles);
		builder.append(", defaultStyleIndex=");
		builder.append(defaultStyleIndex);
		builder.append(", metaData=");
		builder.append(metaData);
		builder.append("]");
		return builder.toString();
	}




	
	
	
	
}
