package org.gcube.data.publishing.gis.publisher.common;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import net.sf.csv4j.CSVWriter;

public class Utils {

	public static String getUUID(){
		return UUID.randomUUID().toString().replaceAll("-", "_");
	}
	public static long resultSetToCSVFile(ResultSet rs, String outFile, boolean writeHeaders)throws IOException,SQLException{
		final FileWriter fileWriter = new FileWriter(outFile);
		final CSVWriter csvWriter = new CSVWriter( fileWriter );	
		
		//csvWriter.writeLine( new String[] { "column1", "column2", "column3" } );
		ResultSetMetaData meta=rs.getMetaData();
		if(writeHeaders){
			List<String> metaFields=new ArrayList<String>();
			for(int i=1;i<=meta.getColumnCount();i++)
				metaFields.add(meta.getColumnName(i));
			csvWriter.writeLine(metaFields);
		}
		
		
		
		long count = 0;
		rs.beforeFirst();
		while(rs.next()){
			String[] record= new String[meta.getColumnCount()];
			for(int column=0;column<record.length;column++){
				String value=rs.getString(column+1);
				record[column]=(value!=null)?value:"null";
				//record[column]=value;
			}
			csvWriter.writeLine(record);
			count++;
		}
		fileWriter.close();
		return count;
	}
}
