package org.gcube.data.publishing.gis.publisher.plugins;


import java.sql.SQLException;
import java.util.UUID;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.publishing.gis.publisher.ServiceContext;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.GISInteraction;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GISData;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.requests.GISRequestConfiguration;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.response.PublishingReport;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.response.PublishingStatus;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.utils.GISXstream;
import org.gcube.data.publishing.gis.publisher.reports.Status;
import org.gcube.data.publishing.gis.publisher.reports.StoredReport;

import com.j256.ormlite.dao.Dao;
import com.thoughtworks.xstream.XStream;

public class InteractionWrapper {

	private static GCUBELog logger= new GCUBELog(InteractionWrapper.class);
	private static XStream xstream=GISXstream.get();
	private static Dao<StoredReport,UUID> reportDao=ServiceContext.getContext().getReportDao();
	
	private final GISInteraction interaction;
	
	public InteractionWrapper(GISInteraction interaction) {
		this.interaction=interaction;
	}
	
	
	public StoredReport publishData(final GISData toPublishData,final GISRequestConfiguration config)throws SQLException{
		PublishingReport toSerialize=new PublishingReport();
		toSerialize.setStatus(PublishingStatus.STARTED);
		StoredReport report=new StoredReport(xstream.toXML(toSerialize),Status.STARTED);
		reportDao.create(report);
		final UUID id=report.getId();	
		Thread t=new Thread(){
			@Override
			public void run() {
				try {
					logger.trace("Launching plugin "+interaction+", report ID "+id);
					PublishingReport report=interaction.publishData(toPublishData, config);
					if(report==null||report.getStatus().equals(Status.STARTED)) throw new Exception("Plugin didn't finished its computation");
					updateReportStatus(id, Status.COMPLETED, xstream.toXML(report));
					logger.trace("report ID "+id+" execution complete!!");
				} catch (Throwable t) {
					logger.error("Unexpected error while executing report ID "+id, t);
					PublishingReport toSerialize=new PublishingReport();
					toSerialize.setStatus(PublishingStatus.ERROR);
					toSerialize.getErrorMessages().put("EXECUTION", t.getMessage());
					try {
						updateReportStatus(id, Status.ERROR, xstream.toXML(toSerialize));
					} catch (SQLException e) {
						logger.error("Unable to update report",e);
					}
				}
			}
		};
		t.start();
		return report;
	}
	
	
	private static void updateReportStatus(UUID id,Status toSet,String serializedContent) throws SQLException{
		StoredReport report=reportDao.queryForId(id);
		report.setStatus(toSet);
		report.setSerializedReport(serializedContent);
		reportDao.update(report);
	}
}
