package org.gcube.data.publishing.gis.publisher;

import java.util.UUID;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.data.publishing.gis.publisher.common.Constants;
import org.gcube.data.publishing.gis.publisher.reports.StoredReport;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.table.TableUtils;

public class ServiceContext extends GCUBEServiceContext{

	/** Single context instance, created eagerly */
	private static ServiceContext cache = new ServiceContext();
	
	/** Returns cached instance */
	public static ServiceContext getContext() {return cache;}
	
	
	@Override
	protected String getJNDIName() {
		return Constants.JNDI_NAME;
	};
	
	private final static String DATABASE_URL = "jdbc:h2:mem:report;DB_CLOSE_DELAY=-1";
	
	@Override
	protected void onInitialisation() throws Exception {
		super.onInitialisation();
		
		//Init reference db
		JdbcConnectionSource connectionSource=new JdbcPooledConnectionSource("jdbc:h2:mem:occurrence;DB_CLOSE_DELAY=-1");
		reportDao=DaoManager.createDao(connectionSource, StoredReport.class);
		try{
			TableUtils.createTable(connectionSource, StoredReport.class);
		}catch(Exception e){
			logger.warn("Unable to create Report Table",e);
		}
	}
	
	@Override
	protected void onReady() throws Exception {
		// TODO Auto-generated method stub
		super.onReady();
	}
	
	@Override
	protected void onShutdown() throws Exception {
		// TODO Auto-generated method stub
		super.onShutdown();
	}
	
	@Override
	protected void onFailure() throws Exception {
		// TODO Auto-generated method stub
		super.onFailure();
	}
	
	//********************************* APPLICATION SPECIFIC
	
	private Dao<StoredReport, UUID> reportDao;
	
	public Dao<StoredReport, UUID> getReportDao() {
		return reportDao;
	}
}
