/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.datasource.tabman;

import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.datapublishing.sdmx.datasource.data.ResultSetExtractor;
import org.gcube.datapublishing.sdmx.datasource.data.utils.SdmxDataWriter;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.TabmanDataRetriever;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.TabmanQuery;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.TabmanResultSetExtractor;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json.Rows;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.manager.retrieval.data.SdmxDataRetrievalWithWriter;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularDataRetrievalManager
implements SdmxDataRetrievalWithWriter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TabmanDataRetriever dataRetriever = new TabmanDataRetriever();

    public void getData(DataQuery dataQuery, DataWriterEngine dataWriter) {
        TabularDataService service = TabularDataServiceFactory.getService();
        String dataStructureid = dataQuery.getDataStructure().getId();
        this.logger.debug("Data structure id " + dataStructureid);
        TabmanQuery query = (TabmanQuery)((Object)this.dataRetriever.generateQueryBuilder().buildDataQuery(dataQuery));
        this.logger.debug("Query generated");
        this.logger.debug("Adding SDMX elements to rs extractor");
        this.logger.debug("Data Writer " + dataWriter.getClass());
        this.logger.debug("Data Query " + dataQuery);
        ResultSetExtractor resultSetExtractor = this.dataRetriever.generateResultSetExtractor(query.getMetadataProvider());
        try {
            query.initQuery(service, true);
            Rows rows = this.executeQuery(service, query);
            ((TabmanResultSetExtractor)resultSetExtractor).processRows(rows);
            SdmxDataWriter dataRetrieval = new SdmxDataWriter(dataQuery);
            dataRetrieval.setDataWriter(dataWriter);
            dataRetrieval.writeData(resultSetExtractor.getSeriesMap());
        }
        catch (Exception e) {
            this.logger.error("Unable to get the data", (Throwable)e);
        }
    }

    private Rows executeQuery(TabularDataService service, TabmanQuery query) throws Exception {
        this.logger.debug("Executing query");
        String jsonResponse = service.queryAsJson(query.getTableId(), null, query.getFilter(), query.getQuerySelectFilter());
        this.logger.debug("Query executed");
        this.logger.debug("JSON response " + jsonResponse);
        Rows response = new Rows(query.getColumnIds());
        response.fromJson(jsonResponse.getBytes());
        this.logger.debug("Bean created");
        return response;
    }
}

