package org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.gcube.datapublishing.sdmx.datasource.data.ResultSetExtractor;
import org.gcube.datapublishing.sdmx.datasource.data.ResultSetExtractorAbstractImpl;
import org.gcube.datapublishing.sdmx.datasource.data.beans.AttributeColumnBean;
import org.gcube.datapublishing.sdmx.datasource.data.beans.DimensionColumnBean;
import org.gcube.datapublishing.sdmx.datasource.series.model.ObservationModel;
import org.gcube.datapublishing.sdmx.datasource.series.model.SeriesModel;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json.RowModel;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json.Rows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabmanResultSetExtractor extends ResultSetExtractorAbstractImpl  implements ResultSetExtractor {

	private Logger logger;
	private Map<String, SeriesModel> seriesModelMap;
	
	public TabmanResultSetExtractor() {
		super ();
		this.logger = LoggerFactory.getLogger(this.getClass());
		this.seriesModelMap = new HashMap<>();
	}

	public void processRows(Rows rows) 
	{
		
		List<RowModel> rowModels = rows.getRows();
		DimensionColumnBean seriesColumn = getSeriesColumnId();
		int seriesColumnIdPosition = this.metadataProvider.getDataPosition(seriesColumn.getId());
		int timeDimensionColumnIdPosition = this.metadataProvider.getDataPosition(this.metadataProvider.getTimeDimension().getId());
		int primaryMeasureColumnIdPosition = this.metadataProvider.getDataPosition(this.metadataProvider.getPrimaryMeasure().getId());
		
		for (int i=0; i<rowModels.size();i++)
		{
			logger.debug("Row "+i);
			processRow(rowModels.get(i),seriesColumnIdPosition,timeDimensionColumnIdPosition,primaryMeasureColumnIdPosition);
		}

	}
	

	private void processRow (RowModel rowModel,int seriesColumnIdPosition, int timeDimensionColumnIdPosition, int primaryMeasureColumnIdPosition)
	{
		logger.debug("Processing new row");
		String serieKeyValue = rowModel.getElement(seriesColumnIdPosition);
		logger.debug("Series key value "+serieKeyValue);
		
		SeriesModel seriesModel = this.seriesModelMap.get(serieKeyValue);
		
		if (seriesModel == null)
		{
			seriesModel = generateNewSeriesModel(rowModel);
			this.seriesModelMap.put(serieKeyValue, seriesModel);
		}
		
		ObservationModel observation = new ObservationModel();
		String observationTime = rowModel.getElement(timeDimensionColumnIdPosition);
		String observationValue = rowModel.getElement(primaryMeasureColumnIdPosition);
		logger.debug("Adding observation of "+observationTime+ " = "+observationValue);
		observation.setId(observationTime);
		observation.setValue(observationValue);
		//Write Observation
		logger.debug("Adding observation attributes");
		//Write Observation Attributes
		
		List<AttributeColumnBean> attributes = this.metadataProvider.getObservationAttributes();
		
		for (AttributeColumnBean attribute : attributes)
		{
			
			String attributeColumnId = attribute.getId();
			String attributeColumnLabel = attribute.getConcept();
			String attributeValue = rowModel.getElement(this.metadataProvider.getDataPosition(attributeColumnId));
			this.logger.debug("Adding observation attribute column "+attributeColumnId+" called "+attributeColumnLabel+" value "+attributeValue);
			
			if (attributeValue != null) observation.addAttribute(attributeColumnLabel,attributeValue);	
	
			else logger.warn("Observation attribute not found");
		}
		
		seriesModel.addObservations(observation);

		
	}
	
	private DimensionColumnBean getSeriesColumnId ()
	{
		Iterator<DimensionColumnBean> dimensions = this.metadataProvider.getDimensions().iterator();
		DimensionColumnBean response = null;
		
		while (dimensions.hasNext() && response == null)
		{
			DimensionColumnBean dimension = dimensions.next();
			
			if (!dimension.isMeasureDimension() && !dimension.isTimeDimension()) response = dimension;
		}
		
		return response;
	}

	
	private SeriesModel generateNewSeriesModel (RowModel rowModel) 
	{
		logger.debug("New series key, adding dimensions");
		SeriesModel response = new SeriesModel();
		logger.debug("Adding generic dimensions");
		
		List<DimensionColumnBean> dimensions = this.metadataProvider.getDimensions();
		
		for (DimensionColumnBean dimension : dimensions)
		{
			
			String dimensionColumnId = dimension.getId();
			String dimensionColumnLabel = dimension.getConcept();
			String dimensionValue = rowModel.getElement(this.metadataProvider.getDataPosition(dimensionColumnId));
			this.logger.debug("Adding dimension column "+dimensionColumnId+" called "+dimensionColumnLabel+" value "+dimensionValue);
			
			if (dimensionValue != null) response.addSeriesDimensions(dimensionColumnLabel, dimensionValue);	
			else logger.warn("Dimension not found");
		}
		
		List<AttributeColumnBean> attributes = this.metadataProvider.getDimensionAttributes();
		
		for (AttributeColumnBean attribute : attributes)
		{
			
			String attributeColumnId = attribute.getId();
			String attributeColumnLabel = attribute.getConcept();
			String attributeValue = rowModel.getElement(this.metadataProvider.getDataPosition(attributeColumnId));
			this.logger.debug("Adding dimension attribute column "+attributeColumnId+" called "+attributeColumnLabel+" value "+attributeValue);
			
			if (attributeValue != null) response.addSeriesAttributes(attributeColumnLabel,attributeValue);	
	
			else logger.warn("Dimension attribute not found");
		}
		
		return response;
	}

	@Override
	public Map<String, SeriesModel> getSeriesMap() {

		return this.seriesModelMap;
	}
	
//	private String getColumnLabel (String componentId, Map<String, String> map)
//	{
//		logger.debug("Getting column value for "+componentId);
//		String columnValue = map.get(componentId);
//		
//		if (columnValue == null)
//		{
//			logger.warn("Column value not found, using component id");
//			columnValue = componentId;
//		}
//		
//		logger.debug("Response value "+columnValue);
//		return columnValue;
//	}

}
