/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json.JSonModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowModel
extends JSonModel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> elements = new ArrayList<String>();
    private List<String> columnIdList;

    public RowModel(List<String> columnIdList) {
        this.columnIdList = columnIdList;
        this.logger.debug("Column ids " + this.columnIdList);
    }

    @Override
    protected void fromJson(JsonParser jp) throws Exception {
        this.logger.debug("JSon Array");
        JsonToken tolkein = jp.getCurrentToken();
        while ((tolkein = jp.nextToken()) != JsonToken.END_ARRAY) {
            String value = jp.getText();
            this.logger.debug("Value " + value);
            this.elements.add(value);
        }
    }

    @Override
    public String toJson() throws Exception {
        StringWriter outBuffer = new StringWriter();
        JsonFactory f = new JsonFactory();
        JsonGenerator g = f.createJsonGenerator((Writer)outBuffer);
        g.useDefaultPrettyPrinter();
        g.writeStartArray();
        Iterator<String> elementsIterator = this.elements.iterator();
        while (elementsIterator.hasNext()) {
            g.writeString(elementsIterator.next());
        }
        g.writeEndArray();
        g.flush();
        return outBuffer.toString();
    }

    public String getElement(int position) {
        return this.elements.get(position);
    }

    @Override
    protected int checkKey(String key) {
        return 0;
    }

    @Override
    protected JSonModel generateInternalObject(String key) {
        return null;
    }

    @Override
    protected JSonModel generateInternalArrayObject(String key, int element) {
        return null;
    }
}

