package org.gcube.datapublishing.sdmx.datasource.tabman;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;

import org.gcube.datapublishing.sdmx.datasource.config.ConfigurationManager;
import org.gcube.datapublishing.sdmx.datasource.config.impl.ConfigurationManagerImpl;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabmanDatasourceConfigurationManager extends ConfigurationManagerImpl implements ConfigurationManager {

	private Logger logger;
	
	public TabmanDatasourceConfigurationManager() {
		this.logger = LoggerFactory.getLogger(TabmanDatasourceConfigurationManager.class);
	}
	
	@Override
	public void init() {
		super.init();
		this.logger.debug("Tabman related configuration");
		this.logger.debug("Setting credentials");
		String scope = ScopeProvider.instance.get();
		this.logger.debug("User scope "+scope );
		
		if (scope == null)
		{
			ApplicationContext context = ContextProvider.get();
			ContainerContext containerContext = context.container();
			String token = containerContext.configuration().startTokens().iterator().next();
			this.logger.debug("Container token "+token);
			SecurityTokenProvider.instance.set(token);
			this.logger.debug("Container scope "+ScopeProvider.instance.get());
		}
	}
	
}
