/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.data.analysis.sdmx.DataInformationProvider;
import org.gcube.data.analysis.sdmx.model.TableIdentificators;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.GreaterOrEquals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.LessOrEquals;
import org.gcube.data.analysis.tabulardata.expression.logical.And;
import org.gcube.data.analysis.tabulardata.expression.logical.Or;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrderDirection;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QueryColumn;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QuerySelect;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.datapublishing.sdmx.datasource.data.BasicQuery;
import org.gcube.datapublishing.sdmx.datasource.data.SDMXMetadataProvider;
import org.gcube.datapublishing.sdmx.datasource.data.SDMXMetadataProviderBuilder;
import org.gcube.datapublishing.sdmx.datasource.data.SDMXMetadataProviderGenerator;
import org.gcube.datapublishing.sdmx.datasource.data.beans.ColumnBean;
import org.gcube.datapublishing.sdmx.datasource.tabman.config.TokenBasedDatasourceConfigurationManager;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.exceptions.InvalidInformationSystemDataException;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.TabmanQuery;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.TabmanQueryBuilder;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.data.DataFactoryMap;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.data.DateConverterMap;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json.exception.InvalidFilterParameterException;
import org.sdmxsource.sdmx.api.model.format.DataQueryFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;

@Configurable(value="tabmanQuery")
public class TabmanQueryImpl
extends BasicQuery
implements DataQueryFormat<TabmanQueryBuilder>,
TabmanQuery,
SDMXMetadataProviderGenerator,
ConfigurableObject {
    private Logger logger;
    private QueryFilter tabmanQueryfilter;
    private QuerySelect tabmanRequestedColumnsFilter;
    private TableId tabmanTableId;
    private TableIdentificators tableIdentificators;
    private List<String> tabmanRequestedColumnIds;
    private Map<String, Column> tabmanColumnsMap;
    private DataFactoryMap dataFactoryMap;
    private DateConverterMap dateConverterMap;
    private QueryOrder queryOrder;
    private TokenBasedDatasourceConfigurationManager configurationManager;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public TabmanQueryImpl() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.tabmanQueryfilter = null;
        this.tabmanRequestedColumnsFilter = null;
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public void initQuery(TabularDataService service, boolean lastTable) throws NoSuchTabularResourceException, NoSuchTableException, InvalidInformationSystemDataException, InvalidFilterParameterException {
        if (this.tableIdentificators == null) {
            this.logger.error("Tabular resource not found for the data flow");
            throw new InvalidInformationSystemDataException("Tabular resource not found for the data flow");
        }
        Table table = null;
        if (lastTable) {
            table = service.getLastTable(new TabularResourceId(this.tableIdentificators.getTabularResourceID()));
            if (table == null) {
                this.logger.error("Tablular resource not found " + this.tableIdentificators.getTabularResourceIDString());
                throw new NoSuchTabularResourceException(this.tableIdentificators.getTabularResourceID());
            }
        } else {
            table = service.getTable(new TableId(this.tableIdentificators.getTableID()));
            if (table == null) {
                this.logger.error("Table not found " + this.tableIdentificators.getTableIDString());
                throw new NoSuchTableException(new TableId(this.tableIdentificators.getTableID()));
            }
        }
        this.tabmanTableId = table.getId();
        this.logger.debug("Table  found: id " + this.tabmanTableId.getValue());
        this.logger.debug("Defining requested columns according to SDMX table columns");
        this.defineRequestedColumns(table.getColumns());
        this.logger.debug("Generating query filter");
        this.buildTabmanQueryFilter();
        this.buildQueryOrder();
        this.logger.debug("Query generated");
    }

    private void buildQueryOrder() {
        this.logger.debug("Looking for the max N results");
        String tabmandimensionColumnId = DataInformationProvider.getInstance().getColumnConverter().registry2Local(this.getTimeDimension().getId());
        if (this.getLastNObservations() > 0) {
            this.logger.debug("Last n observation " + this.getLastNObservations() + " setting descending order");
            this.queryOrder = new QueryOrder(new ColumnLocalId(tabmandimensionColumnId), QueryOrderDirection.DESCENDING);
        } else {
            this.logger.debug("First n observation " + this.getFirstNObservations() + " setting the default ascending order");
            this.queryOrder = new QueryOrder(new ColumnLocalId(tabmandimensionColumnId), QueryOrderDirection.ASCENDING);
        }
    }

    public void setDataFactoryMap(DataFactoryMap dataFactoryMap) {
        this.dataFactoryMap = dataFactoryMap;
    }

    public void setDateConverterMap(DateConverterMap dateConverterMap) {
        this.dateConverterMap = dateConverterMap;
    }

    public void setDataFlow(String agency, String id, String version) {
        super.setDataFlow(agency, id, version);
        this.logger.debug("Loading table identificators from the Information System");
        this.tableIdentificators = this.getTableIdentificators(this.getDataFlowAgency(), this.getDataFlowId(), this.getDataFlowVersion());
    }

    private TableIdentificators getTableIdentificators(String dataFlowAgency, String dataFlowId, String dataFlowVersion) {
        this.logger.debug("Getting table identificators for agency " + dataFlowAgency + " data flow " + dataFlowId + " version " + dataFlowVersion);
        String dataFlowKey = DataInformationProvider.getDataFlowKey((String)dataFlowAgency, (String)dataFlowId, (String)dataFlowVersion);
        this.logger.debug("Data flow key " + dataFlowKey);
        TableIdentificators identificators = DataInformationProvider.getInstance().getTableId(this.configurationManager.getName(), dataFlowKey);
        this.logger.debug("Operation completed with result " + identificators);
        return identificators;
    }

    private void defineRequestedColumns(List<Column> tableColumns) {
        this.logger.debug("Generating the list of requested columns");
        this.tabmanRequestedColumnIds = new LinkedList<String>();
        this.tabmanColumnsMap = new HashMap<String, Column>();
        ArrayList<QueryColumn> tabmanQueryColumns = new ArrayList<QueryColumn>();
        List registryColumnIds = this.getColumnIds();
        for (Column column : tableColumns) {
            ColumnLocalId tabmanLocalId = column.getLocalId();
            String tabmanLocalIdString = tabmanLocalId.getValue();
            String registryColumnIdString = DataInformationProvider.getInstance().getColumnConverter().local2Registry(tabmanLocalIdString);
            this.logger.debug("Registry column id " + registryColumnIdString);
            if (registryColumnIds.remove(registryColumnIdString)) {
                this.logger.debug("Element found");
                tabmanQueryColumns.add(new QueryColumn(tabmanLocalId));
                this.tabmanRequestedColumnIds.add(tabmanLocalIdString);
                this.tabmanColumnsMap.put(tabmanLocalIdString, column);
                continue;
            }
            this.logger.warn("Element " + registryColumnIdString + " not found on the registry: extra column?");
        }
        if (!registryColumnIds.isEmpty()) {
            this.logger.warn("At least one column on the registry has not a corresponding data column!");
            this.logger.debug("Removing all existing extra dimension/attributes from the query");
            this.logger.debug(registryColumnIds.toString());
            for (String toBeRemovedRegistryId : registryColumnIds) {
                this.logger.debug("Id to be removed " + toBeRemovedRegistryId);
                if (!this.removeRegistryColumn(this.getAttributes(), toBeRemovedRegistryId)) {
                    this.logger.debug("column not found among attributes");
                    if (!this.removeRegistryColumn(this.getDimensions(), toBeRemovedRegistryId)) {
                        this.logger.warn("Column not found among dimensions: possible problems");
                        continue;
                    }
                    this.logger.debug("Dimension column removed");
                    continue;
                }
                this.logger.debug("Attribute column removed");
            }
        }
        if (tabmanQueryColumns.size() > 0) {
            this.logger.debug("Generating query select filter");
            this.tabmanRequestedColumnsFilter = new QuerySelect(tabmanQueryColumns);
        } else {
            this.logger.debug("No query select filter generated");
        }
    }

    private boolean removeRegistryColumn(List<? extends ColumnBean> columns, String id) {
        boolean removed = false;
        Iterator<? extends ColumnBean> columnsIterator = columns.iterator();
        while (columnsIterator.hasNext() && !removed) {
            ColumnBean column = columnsIterator.next();
            if (!column.getId().equals(id)) continue;
            columns.remove(column);
            removed = true;
        }
        return removed;
    }

    private Expression buildSingleTabmanColumnExpression(String tabmanColumnId, Set<String> values) throws InvalidFilterParameterException {
        if (values.size() == 1) {
            this.logger.debug("Generating single value expression");
            return this.generateEqualExpression(tabmanColumnId, values.iterator().next());
        }
        if (values.size() > 1) {
            this.logger.debug("Generating or expression");
            LinkedList<Expression> equalsList = new LinkedList<Expression>();
            Iterator<String> valuesIterator = values.iterator();
            while (valuesIterator.hasNext()) {
                equalsList.add(this.generateEqualExpression(tabmanColumnId, valuesIterator.next()));
            }
            return new Or(equalsList);
        }
        return null;
    }

    private void buildTabmanQueryFilter() throws InvalidFilterParameterException {
        this.logger.debug("Generating query filter");
        ArrayList<Expression> andExpressionsList = new ArrayList<Expression>();
        if (!this.getParametersMap().isEmpty()) {
            for (String registryColumnId : this.getParametersMap().keySet()) {
                this.logger.debug("Registry query filter column id " + registryColumnId);
                Set values = (Set)this.getParametersMap().get(registryColumnId);
                String tabmanColumnId = DataInformationProvider.getInstance().getColumnConverter().registry2Local(registryColumnId);
                this.logger.debug("Tabman filter column id " + tabmanColumnId);
                andExpressionsList.add(this.buildSingleTabmanColumnExpression(tabmanColumnId, values));
            }
        }
        String tabmanTimedimensionId = DataInformationProvider.getInstance().getColumnConverter().registry2Local(this.getTimeDimension().getId());
        this.logger.debug("Tabman time dimension column id " + tabmanTimedimensionId);
        ColumnReference leftArgument = new ColumnReference(this.tabmanTableId, new ColumnLocalId(tabmanTimedimensionId));
        this.parseTimeIntervalMaxFilter(andExpressionsList, this.getTimeIntervalMax(), leftArgument, tabmanTimedimensionId);
        this.parseTimeIntervalMinFilter(andExpressionsList, this.getTimeIntervalMin(), leftArgument, tabmanTimedimensionId);
        if (andExpressionsList.size() == 1) {
            this.tabmanQueryfilter = new QueryFilter((Expression)andExpressionsList.get(0));
        } else if (andExpressionsList.size() > 1) {
            this.tabmanQueryfilter = new QueryFilter((Expression)new And(andExpressionsList));
        }
        this.logger.debug("Query filter built");
    }

    private TDTypeValue getDateTDValue(String tabmanTimeDimensionColumnId, Date date) throws InvalidFilterParameterException {
        Column tabmanTimeDimensionColumn = this.tabmanColumnsMap.get(tabmanTimeDimensionColumnId);
        DataType timedimensionDataType = tabmanTimeDimensionColumn.getDataType();
        Object dateObject = this.dateConverterMap.getDateConverter(timedimensionDataType).convertDate(date, tabmanTimeDimensionColumn);
        this.logger.debug("Date object type " + dateObject.getClass().toString());
        return this.dataFactoryMap.getDataFactory(timedimensionDataType).getTypeValue(dateObject, tabmanTimeDimensionColumn);
    }

    private void parseTimeIntervalMinFilter(List<Expression> expressionList, Date timeIntervalMin, ColumnReference leftArgument, String tabmanTimeDimensionColumnId) throws InvalidFilterParameterException {
        if (timeIntervalMin != null) {
            this.logger.debug("Parsing min time filter");
            expressionList.add((Expression)new GreaterOrEquals((Expression)leftArgument, (Expression)this.getDateTDValue(tabmanTimeDimensionColumnId, timeIntervalMin)));
        }
    }

    private void parseTimeIntervalMaxFilter(List<Expression> expressionList, Date timeIntervalMax, ColumnReference leftArgument, String tabmanTimeDimensionColumnId) throws InvalidFilterParameterException {
        if (timeIntervalMax != null) {
            this.logger.debug("Parsing max time filter");
            expressionList.add((Expression)new LessOrEquals((Expression)leftArgument, (Expression)this.getDateTDValue(tabmanTimeDimensionColumnId, timeIntervalMax)));
        }
    }

    private Expression generateEqualExpression(String tabmanColumnId, String queryParameter) throws InvalidFilterParameterException {
        Column tabmanColumn = this.tabmanColumnsMap.get(tabmanColumnId);
        this.logger.debug("Generating expression for " + tabmanColumnId + " with parameter " + queryParameter);
        ColumnReference leftArgument = new ColumnReference(this.tabmanTableId, new ColumnLocalId(tabmanColumnId));
        TDTypeValue rightArgument = this.dataFactoryMap.getDataFactory(tabmanColumn.getDataType()).getTypeValue(queryParameter, tabmanColumn);
        return new Equals((Expression)leftArgument, (Expression)rightArgument);
    }

    public void addParameters(String columnId, Set<String> values) {
        if (columnId.equals("TIME_PERIOD")) {
            columnId = this.tableIdentificators.getTimeDimension();
        } else if (columnId.equals("OBS_VALUE")) {
            columnId = this.tableIdentificators.getPrimaryMeasure();
        }
        super.addParameters(columnId, values);
    }

    public void setTimeDimension(String columnId, String columnConcept) {
        this.logger.debug("Setting time dimension: modifying SDMX column ID " + columnId);
        String timeDimensionId = this.tableIdentificators.getTimeDimension();
        this.logger.debug("Time dimension id " + timeDimensionId);
        super.setTimeDimension(DataInformationProvider.getInstance().getColumnConverter().local2Registry(timeDimensionId), columnConcept);
    }

    public void setPrimaryMeasure(String columnId, String columnConcept) {
        this.logger.debug("Setting primary measure: modifying SDMX column ID " + columnId);
        String primaryMeasureId = this.tableIdentificators.getPrimaryMeasure();
        this.logger.debug("Primary measure id " + primaryMeasureId);
        super.setPrimaryMeasure(DataInformationProvider.getInstance().getColumnConverter().local2Registry(primaryMeasureId), columnConcept);
    }

    @Override
    public QueryFilter getQueryFilter() {
        return this.tabmanQueryfilter;
    }

    @Override
    public QuerySelect getRequestedColumnsFilter() {
        return this.tabmanRequestedColumnsFilter;
    }

    @Override
    public TableId getTableId() {
        return this.tabmanTableId;
    }

    public List<String> getRequestedColumns() {
        return this.tabmanRequestedColumnIds;
    }

    public SDMXMetadataProvider getMetadataProvider() {
        SDMXMetadataProviderBuilder builder = this.getMetadataProviderBuilder();
        LinkedList<String> registryRequestedColumnIds = new LinkedList<String>();
        for (String tabmanColumnID : this.tabmanRequestedColumnIds) {
            registryRequestedColumnIds.add(DataInformationProvider.getInstance().getColumnConverter().local2Registry(tabmanColumnID));
        }
        builder.setColumnIds(registryRequestedColumnIds);
        return builder.generate();
    }

    @Override
    public QueryOrder getQueryOrder() {
        return this.queryOrder;
    }

    public void setConfigurationManager(TokenBasedDatasourceConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    static {
        TabmanQueryImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TabmanQueryImpl.java", TabmanQueryImpl.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 72);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl.TabmanQueryImpl", "", "", ""), 72);
    }
}

