package org.gcube.datapublishing.sdmx.api.publisher;

import java.util.List;

import org.gcube.datapublishing.sdmx.impl.publisher.data.LocalizedText;
import org.gcube.datapublishing.sdmx.impl.publisher.exceptions.PublisherException;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.RegistrationMutableBean;


public interface GCubeSDMXPublisher {
	
	/**
	 * Creates an Agency definition in the root Agency Scheme and submits it to the registry
	 * @param agencyId The AgencyId to be registered
	 * @param names A list of localized names for the Agency
	 */
	public void createAgency(String agencyId, List<LocalizedText> names) throws PublisherException;
	
	public void publish(CodelistBean codelist) throws PublisherException;

	public void publish(ConceptSchemeBean conceptscheme) throws PublisherException;

	public void publish(DataStructureBean datastructure) throws PublisherException;

	public void publish(DataflowBean dataflow) throws PublisherException;

	public void publish(DataProviderSchemeBean dataproviderscheme) throws PublisherException;

	public void publish(ProvisionAgreementBean provisionagreement) throws PublisherException;

	public void  publish(RegistrationMutableBean registration, String timeseriesId, String timeseriesServiceScope) throws PublisherException;
	
	
	
}
