package org.gcube.datapublishing.sdmx.impl.model;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.List;

import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeSDMXRegistryDescriptor implements SDMXRegistryDescriptor {

	enum RegistryInterfaceCode {
		RESTV1, RESTV2, RESTV2_1, SOAPV1, SOAPV2, SOAPV2_1
	}

	Logger logger = LoggerFactory.getLogger(GCubeSDMXRegistryDescriptor.class);

	private boolean dataRetrieved = false;

	private SDMXRegistryDescriptor delegate;

	public String getRest_url_V2_1() {
		if (!dataRetrieved)
			delegate = retrieveData();
		return delegate.getRest_url_V2_1();
	}

	public String getRest_url_V2() {
		if (!dataRetrieved)
			delegate = retrieveData();
		return delegate.getRest_url_V2();
	}

	public String getRest_url_V1() {
		if (!dataRetrieved)
			delegate = retrieveData();
		return delegate.getRest_url_V1();
	}

	public String getSoap_url_V2_1() {
		if (!dataRetrieved)
			delegate = retrieveData();
		return delegate.getSoap_url_V2_1();
	}

	public String getSoap_url_V2() {
		if (!dataRetrieved)
			delegate = retrieveData();
		return delegate.getSoap_url_V2();
	}

	public String getSoap_url_V1() {
		if (!dataRetrieved)
			delegate = retrieveData();
		return delegate.getSoap_url_V2();
	}

	private SDMXRegistryDescriptor retrieveData() {
		SimpleQuery query = queryFor(ServiceEndpoint.class);

		String scope = ScopeProvider.instance.get();
		
		if (scope == null || scope.isEmpty()) {
			logger.error("No scope provided, unable to retrieve SDMX registry");
			return null;
		}
		
		logger.debug("Looking for SDMXRegistry resources on scope: " + scope);
		
		query.addCondition("$resource/Profile/Category/text() eq 'SDMX'");
		query.addCondition("$resource/Profile/Name/text() eq 'SDMXRegistry'");

		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		List<ServiceEndpoint> resources = client.submit(query);

		if (resources.size() > 1 || resources.isEmpty()) {
			logger.error("Invalid number of SDMX registry resources found: " + resources.size());
			return null;
		}
		
		SDMXRegistryDescriptorImpl registry = new SDMXRegistryDescriptorImpl();
		
		for (AccessPoint ap : resources.get(0).profile().accessPoints()) {
			logger.trace("Retrieved " + ap.name() + ": "
					+ ap.address());
			if (ap.name().equals(
					RegistryInterfaceCode.RESTV1.toString()))
				registry.setRest_url_V1(ap.address());
			if (ap.name().equals(
					RegistryInterfaceCode.RESTV2.toString()))
				registry.setRest_url_V2(ap.address());
			if (ap.name().equals(
					RegistryInterfaceCode.RESTV2_1.toString()))
				registry.setRest_url_V2_1(ap.address());
			if (ap.name().equals(
					RegistryInterfaceCode.SOAPV1.toString()))
				registry.setSoap_url_V1(ap.address());
			if (ap.name().equals(
					RegistryInterfaceCode.SOAPV2.toString()))
				registry.setSoap_url_V2(ap.address());
			if (ap.name().equals(
					RegistryInterfaceCode.SOAPV2_1.toString()))
				registry.setSoap_url_V2_1(ap.address());
		}
		dataRetrieved = true;
		logger.debug("SDMX registry resource retrieved from IS");
		return registry;

	}

}
