/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.impl.registry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.gcube.datapublishing.sdmx.SDMXSourceProvider;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;
import org.gcube.datapublishing.sdmx.api.model.versioning.Version;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.RegistryClientExceptionFactory;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXVersionException;
import org.gcube.datapublishing.sdmx.impl.registry.FusionRegistry;
import org.gcube.datapublishing.sdmx.impl.reports.OperationStatus;
import org.gcube.datapublishing.sdmx.impl.reports.SubmissionReport;
import org.gcube.datapublishing.sdmx.security.model.Credentials;
import org.gcube.datapublishing.sdmx.security.model.impl.Base64Credentials;
import org.sdmx.resources.sdmxml.schemas.v21.message.BaseHeaderType;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.QueryRegistrationRequestType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.QueryTypeType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_OUTPUT_FORMAT;
import org.sdmxsource.sdmx.api.manager.output.StructureWriterManager;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.model.StructureWorkspace;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.api.model.format.StructureFormat;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.sdmxbeans.model.SdmxStructureFormat;
import org.sdmxsource.util.io.ReadableDataLocationTmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FusionRegistry
public class FusionRegistryClient
implements SDMXRegistryClient {
    private boolean checkVersion;
    private Logger log = LoggerFactory.getLogger(FusionRegistryClient.class);
    private SDMXRegistryDescriptor registry = null;
    private SDMXRegistryInterfaceType interfaceType = SDMXRegistryInterfaceType.RESTV2_1;
    private StructureWriterManager structureWriterManager = sdmxSourceProvider.getStructureWriterManager();
    private StructureParsingManager structureParsingManager = sdmxSourceProvider.getStructureParsingManager();
    private static SDMXSourceProvider sdmxSourceProvider = new SDMXSourceProvider();

    public FusionRegistryClient() {
    }

    public FusionRegistryClient(SDMXRegistryDescriptor registry) {
        this();
        this.registry = registry;
        this.checkVersion = registry.versionAware();
    }

    public void setInterfaceType(SDMXRegistryInterfaceType interfaceType) {
        switch (interfaceType) {
            case SOAPV1: 
            case SOAPV2: 
            case SOAPV2_1: {
                throw new IllegalArgumentException("Fusion Registry does only support REST protocols.");
            }
        }
        this.interfaceType = interfaceType;
    }

    @Override
    public void setRegistry(SDMXRegistryDescriptor descriptor) {
        this.registry = descriptor;
    }

    @Override
    public SDMXRegistryDescriptor getRegistry() {
        return this.registry;
    }

    @Override
    public SubmissionReport publish(AgencySchemeBean agencyScheme) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)agencyScheme, this.checkVersion);
    }

    @Override
    public SubmissionReport publish(CodelistBean codelist) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)codelist, this.checkVersion);
    }

    @Override
    public SubmissionReport publish(ConceptSchemeBean conceptscheme) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)conceptscheme, this.checkVersion);
    }

    @Override
    public SubmissionReport publish(DataStructureBean datastructure) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)datastructure, this.checkVersion);
    }

    @Override
    public SubmissionReport publish(DataflowBean dataflow) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)dataflow, this.checkVersion);
    }

    @Override
    public SubmissionReport publish(DataProviderSchemeBean dataproviderscheme) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)dataproviderscheme, this.checkVersion);
    }

    @Override
    public SubmissionReport publish(ProvisionAgreementBean provisionagreement) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)provisionagreement, this.checkVersion);
    }

    @Override
    public SubmissionReport publish(RegistrationBean subscription) throws SDMXRegistryClientException {
        String serverResponse;
        this.log.debug("Generating SDMX document");
        String xmlDocument = this.generateSDMXDocument((MaintainableBean)subscription);
        this.log.info("Submitting to registry Maintainable Artifact with URN: " + subscription.getUrn());
        InputStream is = this.POSTQuery(this.getWebServiceUrl(), this.getWebServiceCredentials(), xmlDocument);
        try {
            serverResponse = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            String errorMsg = "Unable to read server response";
            SDMXRegistryClientException exception = new SDMXRegistryClientException(errorMsg);
            exception.initCause(e);
            throw exception;
        }
        this.logServerMessage(serverResponse);
        this.testForErrorMessage(serverResponse);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(IOUtils.toInputStream((String)serverResponse));
            SubmissionReport report = new SubmissionReport();
            String id = (String)xpath.evaluate("//RegistryInterface/SubmitRegistrationsResponse/RegistrationStatus[1]/Registration/@id", document, XPathConstants.STRING);
            report.setId(id);
            String operationStatus = (String)xpath.evaluate("//RegistryInterface/SubmitRegistrationsResponse/RegistrationStatus[1]/StatusMessage/@status", document, XPathConstants.STRING);
            report.setStatus(OperationStatus.valueOf(operationStatus));
            NodeList nl = (NodeList)xpath.evaluate("//RegistryInterface/SubmitRegistrationsResponse/RegistrationStatus[1]/StatusMessage/MessageText/Text", document, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                report.addMessage(nl.item(i).getTextContent());
            }
            this.log.debug("Submission report: " + report);
            return report;
        }
        catch (Exception e) {
            SDMXRegistryClientException exception = new SDMXRegistryClientException("Unable to parse registry response");
            exception.initCause(e);
            throw exception;
        }
    }

    private VersionResult versionOk(String beanVersion, String agencyId, String id, String typeCode, boolean checkVersion) throws SDMXRegistryClientException {
        if (checkVersion) {
            this.log.debug("Checking version: bean version " + beanVersion);
            Version serverVersion = null;
            try {
                serverVersion = this.getVersion(agencyId, id, typeCode);
            }
            catch (SDMXRegistryClientException e) {
                this.log.debug("Unable to get data on the server, setting version to 0");
                serverVersion = new Version(null);
            }
            Version beanVersionObject = new Version(beanVersion);
            return new VersionResult(serverVersion.compareTo(beanVersionObject) < 0, beanVersion, serverVersion.getVersion());
        }
        this.log.debug("Version check disabled");
        return new VersionResult(true, null, null);
    }

    private SubmissionReport publishMaintanableArtefact(MaintainableBean bean, boolean checkVersion) throws SDMXRegistryClientException {
        VersionResult versionResult = this.versionOk(bean.getVersion(), bean.getAgencyId(), bean.getId(), bean.getStructureType().getUrnClass(), checkVersion);
        if (versionResult.result) {
            String serverResponse;
            this.log.debug("Generating SDMX document");
            String xmlDocument = this.generateSDMXDocument(bean);
            this.log.info("Submitting to registry Maintainable Artifact with URN: " + bean.getUrn());
            InputStream is = this.POSTQuery(this.getWebServiceUrl(), this.getWebServiceCredentials(), xmlDocument);
            try {
                serverResponse = IOUtils.toString((InputStream)is);
            }
            catch (IOException e) {
                String errorMsg = "Unable to read server response";
                SDMXRegistryClientException exception = new SDMXRegistryClientException(errorMsg);
                exception.initCause(e);
                throw exception;
            }
            this.logServerMessage(serverResponse);
            this.testForErrorMessage(serverResponse);
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document document = dBuilder.parse(IOUtils.toInputStream((String)serverResponse));
                XPath xpath = XPathFactory.newInstance().newXPath();
                SubmissionReport report = new SubmissionReport();
                String id = (String)xpath.evaluate("//RegistryInterface/SubmitStructureResponse/SubmissionResult[1]/SubmittedStructure/MaintainableObject/URN/text()", document, XPathConstants.STRING);
                report.setId(id);
                String operationStatus = (String)xpath.evaluate("//RegistryInterface/SubmitStructureResponse/SubmissionResult[1]/StatusMessage/@status", document, XPathConstants.STRING);
                report.setStatus(OperationStatus.valueOf(operationStatus));
                NodeList nl = (NodeList)xpath.evaluate("//RegistryInterface/SubmitRegistrationsResponse/RegistrationStatus/StatusMessage/MessageText/Text", document, XPathConstants.NODESET);
                for (int i = 0; i < nl.getLength(); ++i) {
                    report.addMessage(nl.item(i).getNodeValue());
                }
                this.log.trace("Registration report: " + report);
                return report;
            }
            catch (Exception e) {
                String errorMsg = "Error occurred while parsing registry response";
                SDMXRegistryClientException exception = new SDMXRegistryClientException(errorMsg);
                exception.initCause(e);
                throw exception;
            }
        }
        this.log.debug("The version on Fusion Registry is higher");
        String errorMsg = "Invalid version: the version on the server is " + versionResult.serverVersion + " the version to upload is " + versionResult.beanVersion;
        this.log.error(errorMsg);
        throw new SDMXVersionException(bean.getStructureType().getType(), versionResult.beanVersion, versionResult.serverVersion);
    }

    @Override
    public SdmxBeans getAgencyScheme(String agencyId, String id, String version, SDMXRegistryClient.Detail details, SDMXRegistryClient.References references) throws SDMXRegistryClientException {
        return this.getMaintainableArtifacts(agencyId, id, version, details, references, "agencyscheme");
    }

    @Override
    public SdmxBeans getCodelist(String agencyId, String id, String version, SDMXRegistryClient.Detail details, SDMXRegistryClient.References references) throws SDMXRegistryClientException {
        return this.getMaintainableArtifacts(agencyId, id, version, details, references, "codelist");
    }

    @Override
    public SdmxBeans getConceptScheme(String agencyId, String id, String version, SDMXRegistryClient.Detail details, SDMXRegistryClient.References references) throws SDMXRegistryClientException {
        return this.getMaintainableArtifacts(agencyId, id, version, details, references, "conceptscheme");
    }

    @Override
    public SdmxBeans getDataStructure(String agencyId, String id, String version, SDMXRegistryClient.Detail details, SDMXRegistryClient.References references) throws SDMXRegistryClientException {
        return this.getMaintainableArtifacts(agencyId, id, version, details, references, "datastructure");
    }

    @Override
    public SdmxBeans getDataFlow(String agencyId, String id, String version, SDMXRegistryClient.Detail details, SDMXRegistryClient.References references) throws SDMXRegistryClientException {
        return this.getMaintainableArtifacts(agencyId, id, version, details, references, "dataflow");
    }

    @Override
    public SdmxBeans getDataProviderScheme(String agencyId, String id, String version, SDMXRegistryClient.Detail details, SDMXRegistryClient.References references) throws SDMXRegistryClientException {
        return this.getMaintainableArtifacts(agencyId, id, version, details, references, "dataproviderscheme");
    }

    @Override
    public SdmxBeans getProvisionAgreement(String agencyId, String id, String version, SDMXRegistryClient.Detail details, SDMXRegistryClient.References references) throws SDMXRegistryClientException {
        return this.getMaintainableArtifacts(agencyId, id, version, details, references, "provisionagreement");
    }

    @Override
    public SdmxBeans getAllDataSetRegistrations() throws SDMXRegistryClientException {
        String serverResponse;
        RegistryInterfaceDocument document = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType registryInterfaceType = document.addNewRegistryInterface();
        BaseHeaderType baseHeader = registryInterfaceType.addNewHeader();
        baseHeader.setID("UNKNOWN");
        baseHeader.setTest(false);
        baseHeader.setPrepared(Calendar.getInstance());
        baseHeader.addNewSender().setId("sdmx-publisher");
        baseHeader.addNewReceiver().setId("REGISTRY");
        registryInterfaceType.setHeader(baseHeader);
        QueryRegistrationRequestType queryRegistrationRequestType = registryInterfaceType.addNewQueryRegistrationRequest();
        queryRegistrationRequestType.setQueryType(QueryTypeType.DATA_SETS);
        queryRegistrationRequestType.addNewAll();
        String xmlDocument = document.toString();
        this.log.trace("Generated registration query document:\n" + xmlDocument);
        InputStream is = this.POSTQuery(this.getWebServiceUrl(), this.getWebServiceCredentials(), xmlDocument);
        try {
            serverResponse = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            String errorMsg = "Unable to read server response";
            SDMXRegistryClientException exception = new SDMXRegistryClientException(errorMsg);
            exception.initCause(e);
            throw exception;
        }
        this.logServerMessage(serverResponse);
        this.testForErrorMessage(serverResponse);
        return this.getStructureBeansFromStream(IOUtils.toInputStream((String)serverResponse));
    }

    private SdmxBeans getMaintainableArtifacts(String agencyId, String id, String version, SDMXRegistryClient.Detail details, SDMXRegistryClient.References references, String typeCode) throws SDMXRegistryClientException {
        this.log.info("Retrieving Maintainable Artifact (" + typeCode + ") with ref: " + agencyId + ", " + id + ", " + version + " from Registry");
        String webService = this.getWebServiceUrl();
        webService = webService + typeCode + "/" + agencyId + "/" + id + "/" + version + "/?detail=" + details.toString() + "&references=" + references.toString();
        InputStream is = this.GETQuery(webService, this.getWebServiceCredentials());
        ReadableDataLocationTmp structureLocation = new ReadableDataLocationTmp(is);
        StructureWorkspace workspace = this.structureParsingManager.parseStructures((ReadableDataLocation)structureLocation);
        return workspace.getStructureBeans(false);
    }

    private String getWebServiceUrl() throws SDMXRegistryClientException {
        String webService = null;
        switch (this.interfaceType) {
            case RESTV1: 
            case RESTV2: 
            case RESTV2_1: {
                webService = this.registry.getUrl(this.interfaceType);
                break;
            }
            default: {
                throw new SDMXRegistryClientException("Interface " + this.interfaceType.getName() + " not Implemented");
            }
        }
        this.log.debug("Using web service URL: " + webService);
        return webService;
    }

    private String getWebServiceCredentials() throws SDMXRegistryClientException {
        String base64Credentials = null;
        if (this.registry.getUrl(this.interfaceType).startsWith("https")) {
            switch (this.interfaceType) {
                case RESTV1: 
                case RESTV2: 
                case RESTV2_1: {
                    Credentials credentials = this.registry.getCredentials();
                    if (credentials == null || !credentials.getType().equals(Base64Credentials.CREDENTIAL_TYPE)) break;
                    base64Credentials = ((Base64Credentials)credentials).getBase64Encoding();
                    break;
                }
                default: {
                    throw new SDMXRegistryClientException("Interface " + this.interfaceType.getName() + " not Implemented");
                }
            }
            this.log.debug("Credentials: " + base64Credentials);
        } else {
            this.log.debug("No secure connection: credentials will not be sent");
        }
        return base64Credentials;
    }

    private String generateSDMXDocument(MaintainableBean bean) throws SDMXRegistryClientException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        switch (this.interfaceType) {
            case RESTV1: {
                this.structureWriterManager.writeStructure(bean, null, (StructureFormat)new SdmxStructureFormat(STRUCTURE_OUTPUT_FORMAT.SDMX_V1_STRUCTURE_DOCUMENT), (OutputStream)baos);
                break;
            }
            case RESTV2: {
                this.structureWriterManager.writeStructure(bean, null, (StructureFormat)new SdmxStructureFormat(STRUCTURE_OUTPUT_FORMAT.SDMX_V2_STRUCTURE_DOCUMENT), (OutputStream)baos);
                break;
            }
            case RESTV2_1: {
                this.structureWriterManager.writeStructure(bean, null, (StructureFormat)new SdmxStructureFormat(STRUCTURE_OUTPUT_FORMAT.SDMX_V21_STRUCTURE_DOCUMENT), (OutputStream)baos);
                break;
            }
            default: {
                throw new SDMXRegistryClientException("Interface " + this.interfaceType.getName() + " not Implemented");
            }
        }
        return baos.toString();
    }

    private InputStream POSTQuery(String queryUrl, String base64Credentials, String queryDocument) throws SDMXRegistryClientException {
        InputStream is;
        PrintStream ps;
        URLConnection urlc;
        URL url;
        this.log.trace("Submitting SDMX document to Registry URL: " + queryUrl + ", Document: " + queryDocument);
        try {
            url = new URL(queryUrl);
        }
        catch (MalformedURLException e) {
            String msg = "Malformed query URL";
            SDMXRegistryClientException exception = new SDMXRegistryClientException(msg);
            exception.initCause(e);
            throw exception;
        }
        try {
            urlc = url.openConnection();
        }
        catch (IOException e) {
            String msg = "Unable to open a connection to the registry";
            SDMXRegistryClientException exception = new SDMXRegistryClientException(msg);
            exception.initCause(e);
            throw exception;
        }
        urlc.setDoOutput(true);
        urlc.setAllowUserInteraction(false);
        urlc.addRequestProperty("Accept", "application/xml;version=" + this.interfaceType.getModelVersion());
        urlc.addRequestProperty("Content-Type", "application/text");
        if (base64Credentials != null) {
            urlc.addRequestProperty("Authorization", "Basic " + base64Credentials);
        }
        try {
            ps = new PrintStream(urlc.getOutputStream());
        }
        catch (IOException e) {
            String msg = "Unable to send message to the registry";
            SDMXRegistryClientException exception = new SDMXRegistryClientException(msg);
            exception.initCause(e);
            throw exception;
        }
        ps.print(queryDocument);
        ps.close();
        try {
            is = urlc.getInputStream();
        }
        catch (IOException e) {
            String msg = "Unable to read response from registry";
            SDMXRegistryClientException exception = new SDMXRegistryClientException(msg);
            exception.initCause(e);
            throw exception;
        }
        return is;
    }

    private InputStream GETQuery(String queryUrl, String base64Credentials) throws SDMXRegistryClientException {
        String response;
        URLConnection urlc;
        URL url;
        try {
            url = new URL(queryUrl);
        }
        catch (MalformedURLException e) {
            this.log.error("Invalid query URL was generated: " + queryUrl);
            throw new SDMXRegistryClientException("Syntax error");
        }
        try {
            urlc = url.openConnection();
        }
        catch (IOException e) {
            this.log.error("Unable to open a connection to the registry", (Throwable)e);
            throw new SDMXRegistryClientException("Unable to contact registry");
        }
        urlc.setDoOutput(false);
        urlc.setAllowUserInteraction(false);
        urlc.setRequestProperty("Accept", "application/xml;version=" + this.interfaceType.getModelVersion());
        if (base64Credentials != null) {
            urlc.addRequestProperty("Authorization", "Basic " + base64Credentials);
        }
        try {
            this.log.trace("Performing GET Query with URL: " + urlc.getURL());
            InputStream is = urlc.getInputStream();
            response = IOUtils.toString((InputStream)is);
            this.log.debug("Registry response:\n" + response);
        }
        catch (IOException e) {
            this.log.error("Unable to open a connection to the registry");
            SDMXRegistryClientException exception = new SDMXRegistryClientException("Unable to read response message from registry");
            exception.initCause(e);
            throw exception;
        }
        return IOUtils.toInputStream((String)response);
    }

    private SdmxBeans getStructureBeansFromStream(InputStream is) {
        ReadableDataLocationTmp structureLocation = new ReadableDataLocationTmp(is);
        StructureWorkspace workspace = this.structureParsingManager.parseStructures((ReadableDataLocation)structureLocation);
        return workspace.getStructureBeans(false);
    }

    private void logServerMessage(String serverResponse) {
        this.log.trace("Registry response:\n" + serverResponse);
    }

    private void testForErrorMessage(String serverResponse) throws SDMXRegistryClientException {
        this.log.debug("Server Response:");
        this.log.debug(serverResponse);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(IOUtils.toInputStream((String)serverResponse));
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node errorNode = (Node)xpath.evaluate("/Error", document, XPathConstants.NODE);
            if (errorNode == null) {
                return;
            }
            Double code = (Double)xpath.evaluate("/Error/ErrorMessage/@code", document, XPathConstants.NUMBER);
            this.log.trace("Error message code: " + String.valueOf(code.intValue()));
            String errorMsg = (String)xpath.evaluate("/Error/ErrorMessage/Text/text()", document, XPathConstants.STRING);
            this.log.trace("Error message text: " + errorMsg);
            throw RegistryClientExceptionFactory.getException(errorMsg, code.intValue());
        }
        catch (SDMXRegistryClientException e) {
            this.log.info("Caught error message from registry: " + e);
            throw e;
        }
        catch (Exception e) {
            String msg = "Exception caught while checking for error messages in server response";
            SDMXRegistryClientException exception = new SDMXRegistryClientException(msg);
            exception.initCause(e);
            throw exception;
        }
    }

    private Version getVersion(String agencyId, String id, String typeCode) throws SDMXRegistryClientException {
        this.log.debug("Checking if the a newer version exists on the registry");
        SdmxBeans beans = this.getMaintainableArtifacts(agencyId, id, "", SDMXRegistryClient.Detail.referencestubs, SDMXRegistryClient.References.none, typeCode);
        Version response = new Version(null);
        Set responseBeans = beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]);
        for (MaintainableBean responseBean : responseBeans) {
            Version version = new Version(responseBean.getVersion());
            if (version.compareTo(response) <= 0) continue;
            response = version;
        }
        this.log.debug("Registry version " + response);
        return response;
    }

    @Override
    public SubmissionReport publish(AgencySchemeBean agencyScheme, boolean versionAware) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)agencyScheme, versionAware);
    }

    @Override
    public SubmissionReport publish(CodelistBean codelist, boolean versionAware) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)codelist, versionAware);
    }

    @Override
    public SubmissionReport publish(ConceptSchemeBean conceptscheme, boolean versionAware) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)conceptscheme, versionAware);
    }

    @Override
    public SubmissionReport publish(DataStructureBean datastructure, boolean versionAware) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)datastructure, versionAware);
    }

    @Override
    public SubmissionReport publish(DataflowBean dataflow, boolean versionAware) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)dataflow, versionAware);
    }

    @Override
    public SubmissionReport publish(DataProviderSchemeBean dataproviderscheme, boolean versionAware) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)dataproviderscheme, versionAware);
    }

    @Override
    public SubmissionReport publish(ProvisionAgreementBean provisionagreement, boolean versionAware) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)provisionagreement, versionAware);
    }

    @Override
    public SubmissionReport publish(RegistrationBean subscription, boolean versionAware) throws SDMXRegistryClientException {
        return this.publishMaintanableArtefact((MaintainableBean)subscription, versionAware);
    }

    private class VersionResult {
        public boolean result;
        public String beanVersion;
        public String serverVersion;

        public VersionResult(boolean result, String beanVersion, String serverVersion) {
            this.result = result;
            this.beanVersion = beanVersion;
            this.serverVersion = serverVersion;
        }
    }
}

