/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.security;

import java.security.Key;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.soap.SOAPFaultException;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datapublishing.sdmx.is.ISReader;
import org.gcube.datapublishing.sdmx.model.Registry;
import org.gcube.datapublishing.sdmx.security.model.impl.BasicCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISRegistryDataReader
extends ISReader<ServiceEndpoint.AccessPoint> {
    private final String CATEGORY = "Category";
    private final String SDMX = "SDMX";
    private final String NAME = "Name";
    private final String REGISTRY = "SDMXRegistry";
    private final String ENDPOINT = "AccessPoint/Interface/Endpoint";
    private final String RESULTS = "$resource/Profile/AccessPoint";
    private Logger logger = LoggerFactory.getLogger(ISRegistryDataReader.class);

    public List<ServiceEndpoint.AccessPoint> getAccessPoints(String endpoint) {
        this.logger.debug("Getting access point " + endpoint);
        super.newQuery(ServiceEndpoint.class);
        super.addCondition("Category", "SDMX");
        super.addCondition("Name", "SDMXRegistry");
        if (endpoint != null) {
            super.addCondition("AccessPoint/Interface/Endpoint", endpoint.trim());
        }
        super.setResults("$resource/Profile/AccessPoint");
        return super.submit(ServiceEndpoint.AccessPoint.class);
    }

    public Registry getRegistry(String protocol) {
        Registry response = null;
        this.logger.debug("Getting access point for protocol " + protocol);
        ServiceEndpoint.AccessPoint accessPoint = this.getAccessPoint(null, protocol);
        if (accessPoint != null) {
            this.logger.debug("Access point found " + accessPoint.address());
            response = new Registry();
            response.setEndpoint(accessPoint.address());
            response.setCredentials(this.getCredentials(accessPoint));
        } else {
            this.logger.debug("Access point not found");
        }
        return response;
    }

    private ServiceEndpoint.AccessPoint getAccessPoint(String endpoint, String protocol) {
        this.logger.debug("Getting access points list for " + endpoint + " and protocol " + protocol);
        ServiceEndpoint.AccessPoint response = null;
        List<ServiceEndpoint.AccessPoint> accessPoints = this.getAccessPoints(endpoint);
        if (accessPoints == null) {
            this.logger.warn("No access point found on IS!!!");
        } else {
            Iterator<ServiceEndpoint.AccessPoint> accessPointIterator = accessPoints.iterator();
            while (accessPointIterator.hasNext() && response == null) {
                ServiceEndpoint.AccessPoint accessPoint = accessPointIterator.next();
                String accessPointProtocol = accessPoint.name();
                this.logger.debug("Access point for " + accessPointProtocol);
                if (!protocol.equalsIgnoreCase(accessPointProtocol)) continue;
                this.logger.debug("Protocol found");
                response = accessPoint;
            }
            this.logger.debug("Access point " + response);
        }
        return response;
    }

    private BasicCredentials getCredentials(ServiceEndpoint.AccessPoint accessPoint) {
        if (accessPoint == null || accessPoint.username() == null || accessPoint.username().trim().length() == 0) {
            this.logger.debug("No credentials present");
            return new BasicCredentials(null, null);
        }
        this.logger.debug("Username " + accessPoint.username());
        try {
            return new BasicCredentials(accessPoint.username(), this.decryptPassword(accessPoint.password()));
        }
        catch (Exception e) {
            this.logger.error("Unable to decrypt password", (Throwable)e);
            return new BasicCredentials(null, null);
        }
    }

    public BasicCredentials getCredentials(String endpoint, String protocol) {
        this.logger.debug("Getting access points list for " + endpoint + " and protocol " + protocol);
        return this.getCredentials(this.getAccessPoint(endpoint, protocol));
    }

    private String decryptPassword(String originalPassword) throws Exception {
        this.logger.debug("Encrypted password " + originalPassword);
        String response = StringEncrypter.getEncrypter().decrypt(originalPassword, new Key[0]);
        return response;
    }

    public static void main(String[] args) {
        ScopeProvider.instance.set("/gcube/devNext/NextNext");
        try {
            List<ServiceEndpoint.AccessPoint> aps = new ISRegistryDataReader().getAccessPoints("http://node8.d.d4science.research-infrastructures.eu:8080/FusionRegistry/ws/rest/");
            for (ServiceEndpoint.AccessPoint ap : aps) {
                System.out.println(ap.address());
                System.out.println(ap.name());
                System.out.println(ap.username());
                System.out.println(ap.password());
                System.out.println("********************");
            }
        }
        catch (RuntimeException e) {
            SOAPFaultException soap = (SOAPFaultException)e.getCause();
            System.out.println(soap.getMessage());
            System.out.println(soap.getFault());
        }
    }
}

