/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import gr.i2s.fishgrowth.model.SampleData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.gcube.data.simulfishgrowthdata.util.ExcelReader;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDataReader
extends ExcelReader {
    protected static final Logger logger = LoggerFactory.getLogger(ExcelDataReader.class);
    private static final double TEMPERATURE_OUT_OF_RANGE = 9999.0;
    int dateFromIdx = 1;
    int dateToIdx = 2;
    int openWeightIdx = 3;
    int closeWeightIdx = 4;
    int avgTemperatureIdx = 5;
    int openFishNoIdx = 6;
    int closeFishNoIdx = 7;
    int fcrIdx = 8;
    int mortalityRateIdx = 9;
    int sfrIdx = 10;
    int sgrIdx = 10;
    int headersCount = 1;

    protected ExcelDataReader() {
    }

    @Override
    protected void importWorkbook(Session session, long simulModelId, String uploadSource, Workbook workbook) {
        Sheet sheet = workbook.getSheetAt(0);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Sheet 0 %s", sheet));
        }
        int rowcnt = 0;
        for (Row row : sheet) {
            logger.debug(String.format("Row [%s] ------------------------------------------------------", ++rowcnt));
            if (rowcnt <= this.headersCount) {
                logger.debug(String.format("Row [%s] is header (%s row are headers)", rowcnt, this.headersCount));
                continue;
            }
            SampleData data = new SampleData();
            data.setSimulModelId(simulModelId);
            data.setUploadSource(uploadSource);
            data.setDateFrom(row.getCell(this.dateFromIdx).getDateCellValue());
            data.setDateTo(row.getCell(this.dateToIdx).getDateCellValue());
            data.setOpenWeight(row.getCell(this.openWeightIdx).getNumericCellValue());
            data.setCloseWeight(row.getCell(this.closeWeightIdx).getNumericCellValue());
            data.setAvgTemperature((int)row.getCell(this.avgTemperatureIdx).getNumericCellValue());
            data.setOpenFishNo((int)row.getCell(this.openFishNoIdx).getNumericCellValue());
            data.setCloseFishNo((int)row.getCell(this.closeFishNoIdx).getNumericCellValue());
            data.setFcr(row.getCell(this.fcrIdx).getNumericCellValue());
            data.setSfr(row.getCell(this.sfrIdx).getNumericCellValue());
            data.setSgr(row.getCell(this.sgrIdx).getNumericCellValue());
            Cell cell = row.getCell(this.mortalityRateIdx);
            if (cell.getCellTypeEnum() == CellType.BLANK) {
                data.setMortalityRate(9999.0);
            } else {
                data.setMortalityRate(cell.getNumericCellValue());
            }
            logger.debug(String.format("Inserting from row [%s] data [%s] ", rowcnt, data));
            session.save((Object)data);
        }
    }
}

