/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import gr.i2s.fishgrowth.model.Scenario;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.calc.ConsumptionScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.calc.ScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioUtil
extends BaseUtil {
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Scenario s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final Logger logger = LoggerFactory.getLogger(ScenarioUtil.class);

    public Scenario add(Scenario scenario) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.save((Object)scenario);
            session.flush();
            session.getTransaction().commit();
            Scenario scenario2 = scenario;
            return scenario2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not add scenario [%s]", scenario), (Throwable)e);
            throw new Exception(String.format("Could not add scenario [%s]", scenario), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Scenario update(Scenario scenario) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.update((Object)scenario);
            session.flush();
            session.getTransaction().commit();
            Scenario scenario2 = scenario;
            return scenario2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not update scenario [%s]", scenario), (Throwable)e);
            throw new Exception(String.format("Could not update scenario [%s]", scenario), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Scenario scenario = (Scenario)session.get(Scenario.class, (Serializable)id);
            if (scenario != null) {
                session.delete((Object)scenario);
                session.flush();
            }
            session.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete scenario [%s]", id), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Scenario getScenario(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Scenario scenario = (Scenario)session.get(Scenario.class, (Serializable)id);
            session.getTransaction().commit();
            Scenario scenario2 = scenario;
            return scenario2;
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve scenario [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not retrieve scenario [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public List<Scenario> getScenarios(String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getScenarios", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return Scenarios %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve scenarios for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve scenarios for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public Scenario executeScenario(Long id) throws Exception {
        try {
            Scenario scenario = this.getScenario(id);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("For [%s] I loaded [%s]", id, scenario));
            }
            new ScenarioExecutor(scenario).run();
            return scenario;
        }
        catch (Exception e) {
            logger.info(String.format("Could not execute scenario [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not execute scenario [%s]", id), e);
        }
    }

    public String executeConsumptionScenario(String from, String to, Integer weight, Integer count, Long modelId) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
        Scenario scenario = new Scenario();
        scenario.setStartDate(df.parse(from));
        scenario.setTargetDate(df.parse(to));
        scenario.setWeight((double)weight.intValue() / 100.0);
        scenario.setFishNo(count.intValue());
        scenario.setModelerId(modelId.longValue());
        ConsumptionScenarioExecutor executor = new ConsumptionScenarioExecutor(scenario);
        executor.run();
        return scenario.getResultsGraphData();
    }
}

