/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import gr.i2s.fishgrowth.model.Sfr;
import java.util.List;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfrUtil
extends BaseUtil {
    private static final String _GET_ALL_ON_MODELER = "FROM gr.i2s.fishgrowth.model.Sfr s WHERE s.modelerId = :modelerId ORDER BY s.temperature ASC, fromWeight DESC";
    private static final String _DEL_ALL_ON_MODELER = "DELETE FROM gr.i2s.fishgrowth.model.Sfr s WHERE s.modelerId = :modelerId";
    private static final Logger logger = LoggerFactory.getLogger(SfrUtil.class);

    public List<Sfr> getSfrs(Long modelId) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_MODELER).setParameter("modelerId", (Object)modelId);
            List list = q.list();
            session.getTransaction().commit();
            List list2 = list;
            return list2;
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve sfr for modelid [%s]", modelId), (Throwable)e);
            throw new Exception("not found");
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteAll(Long modelId) {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            int count = this.doDeleteAll(session, modelId);
            session.getTransaction().commit();
            int n = count;
            return n;
        }
        catch (Exception e) {
            logger.error("Could not delete", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public int doDeleteAll(Session session, Long modelId) {
        Query q = session.createQuery(_DEL_ALL_ON_MODELER).setParameter("modelerId", (Object)modelId);
        int count = q.executeUpdate();
        return count;
    }
}

