/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.SimilarSite;
import gr.i2s.fishgrowth.model.Site;
import gr.i2s.fishgrowth.model.Usage;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil;
import org.gcube.data.simulfishgrowthdata.api.base.SimilarSiteUtil;
import org.gcube.data.simulfishgrowthdata.api.base.SiteFullUtil;
import org.gcube.data.simulfishgrowthdata.util.DatabaseUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteUtil
extends BaseUtil {
    private static final String _GET_ON_OWNERID_DESIGNATION = "FROM gr.i2s.fishgrowth.model.Site s WHERE s.ownerId = :ownerid AND s.designation = :designation";
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Site s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final String _GET_USAGE_ON_OWNERID = "SELECT us.id as id, us.simulcount as usage FROM siteusageview us inner join site e on (us.id=e.id) WHERE e.ownerId = :ownerid ORDER BY us.id ASC";
    private static final String _DELETE_FROM_SIMILARS = "DELETE FROM SimilarSite s WHERE s.siteId=:siteId OR similarId = :siteId";
    private static final String _GET_AS_GLOBAL = "Select 0 as id, cast ('ownerid' as VARCHAR) as \"ownerId\", cast ('designation' as VARCHAR) as \"designation\", cast (round(avg(periodJana)) as INTEGER) as \"periodJanA\", cast (round(avg(periodJanb)) as INTEGER) as \"periodJanB\", cast (round(avg(periodFeba)) as INTEGER) as \"periodFebA\", cast (round(avg(periodFebb)) as INTEGER) as \"periodFebB\", cast (round(avg(periodMara)) as INTEGER) as \"periodMarA\", cast (round(avg(periodMarb)) as INTEGER) as \"periodMarB\", cast (round(avg(periodapra)) as INTEGER) as \"periodAprA\", cast (round(avg(periodaprb)) as INTEGER) as \"periodAprB\", cast (round(avg(periodMaya)) as INTEGER) as \"periodMayA\", cast (round(avg(periodMayb)) as INTEGER) as \"periodMayB\", cast (round(avg(periodJuna)) as INTEGER) as \"periodJunA\", cast (round(avg(periodJunb)) as INTEGER) as \"periodJunB\", cast (round(avg(periodJula)) as INTEGER) as \"periodJulA\", cast (round(avg(periodJulb)) as INTEGER) as \"periodJulB\", cast (round(avg(periodauga)) as INTEGER) as \"periodAugA\", cast (round(avg(periodaugb)) as INTEGER) as \"periodAugB\", cast (round(avg(periodSepa)) as INTEGER) as \"periodSepA\", cast (round(avg(periodSepb)) as INTEGER) as \"periodSepB\", cast (round(avg(periodOcta)) as INTEGER) as \"periodOctA\", cast (round(avg(periodOctb)) as INTEGER) as \"periodOctB\", cast (round(avg(periodNova)) as INTEGER) as \"periodNovA\", cast (round(avg(periodNovb)) as INTEGER) as \"periodNovB\", cast (round(avg(periodDeca)) as INTEGER) as \"periodDecA\", cast (round(avg(periodDecb)) as INTEGER) as \"periodDecB\", 1 as \"oxygenRatingId\", 1 as \"currentRatingId\", 1 as \"regionId\", cast ('' as VARCHAR) as \"latitude\", cast ('' as VARCHAR) as \"longitude\", cast (round(avg(periodyear)) as INTEGER) as \"periodYear\" FROM Site where id in (:siteids)";
    private static final Logger logger = LoggerFactory.getLogger(SiteUtil.class);

    public Site add(Site site) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.save((Object)site);
            this.manageSimilars(session, site);
            session.flush();
            session.getTransaction().commit();
            Site site2 = site;
            return site2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not add site [%s]", site), (Throwable)e);
            throw new Exception(String.format("Could not add site [%s]", site), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Site update(Site site) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.update((Object)site);
            this.manageSimilars(session, site);
            session.flush();
            session.getTransaction().commit();
            Site site2 = site;
            return site2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not update site [%s]", site), (Throwable)e);
            throw new Exception(String.format("Could not update site [%s]", site), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public boolean delete(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            if (this.doDelete(session, id)) {
                session.flush();
            }
            session.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete site [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not delete site [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Site getSite(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Site site = (Site)session.get(Site.class, (Serializable)id);
            session.getTransaction().commit();
            Site site2 = site;
            return site2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not retrieve site [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not retrieve site [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public List<Site> getSites(String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getSites", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return SiteFulls %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve sites for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve sites for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public List<Usage> getUsage(String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getUsage", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createSQLQuery(_GET_USAGE_ON_OWNERID).addEntity(Usage.class).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return site usage %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not get site usage for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not get site usage for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    private void manageSimilars(Session session, Site site) throws Exception {
        Long id = site.getId();
        TreeSet<Long> existingSimilarSites = new TreeSet<Long>(new SimilarSiteUtil().doGetSimilarSites(session, id));
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Existing similars [%s]", existingSimilarSites));
        }
        int dtemp = 1;
        TreeSet<Long> newSimilarSites = new TreeSet<Long>(new SiteFullUtil().doGetSiteFullSimilar(session, site, dtemp));
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("New similars [%s]", newSimilarSites));
        }
        TreeSet<Long> currentSimilarSites = new TreeSet<Long>((Collection<Long>)newSimilarSites);
        currentSimilarSites.add(id);
        if (newSimilarSites.equals(existingSimilarSites)) {
            logger.trace("this relations are already wired regarding the similarity");
        } else {
            Site globalPreviousExisting = this.getGlobalSiteForTheseSites(session, existingSimilarSites);
            Site globalPreviousNew = this.getGlobalSiteForTheseSites(session, newSimilarSites);
            this.doDelete(session, globalPreviousExisting);
            this.doDelete(session, globalPreviousNew);
            this.doDeleteFromSimilars(session, id);
            if (existingSimilarSites.contains(id)) {
                existingSimilarSites.remove(id);
            }
            for (Long newId : currentSimilarSites) {
                SimilarSite similarSite = new SimilarSite(id.longValue(), newId.longValue(), -1);
                session.save((Object)similarSite);
                if (newId == id) continue;
                similarSite = new SimilarSite(newId.longValue(), id.longValue(), -1);
                session.save((Object)similarSite);
            }
            Site globalCurrentExisting = this.generateGlobal(session, existingSimilarSites);
            Site site2 = this.generateGlobal(session, currentSimilarSites);
        }
    }

    private Site generateGlobal(Session session, Set<Long> similarSites) {
        if (similarSites == null || similarSites.isEmpty()) {
            return null;
        }
        Site global = this.doGetSiteAsGlobal(session, similarSites);
        global.setDesignation(DatabaseUtil.getGlobalName(similarSites));
        global.setOwnerId("global");
        session.save((Object)global);
        Long id = global.getId();
        SimilarSite similarSite = new SimilarSite(id.longValue(), id.longValue(), -1);
        session.save((Object)similarSite);
        for (Long simId : similarSites) {
            similarSite = new SimilarSite(id.longValue(), simId.longValue(), -1);
            session.save((Object)similarSite);
            similarSite = new SimilarSite(simId.longValue(), id.longValue(), -1);
            session.save((Object)similarSite);
        }
        return global;
    }

    private Site getGlobalSiteForTheseSites(Session session, Set<Long> sites) {
        if (sites == null || sites.isEmpty()) {
            return null;
        }
        String globalSiteName = DatabaseUtil.getGlobalName(sites);
        Site site = this.doGetSite(session, "global", globalSiteName);
        return site;
    }

    private Site doGetSite(Session session, String ownerId, String designation) {
        Query q = session.createQuery(_GET_ON_OWNERID_DESIGNATION).setParameter("ownerid", (Object)ownerId).setParameter("designation", (Object)designation);
        List list = q.list();
        return (Site)list.get(0);
    }

    private Site doGetSiteAsGlobal(Session session, @Nonnull Set<Long> ids) {
        Query q = session.createSQLQuery(_GET_AS_GLOBAL).setParameterList("siteids", ids).setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(Site.class));
        List list = q.list();
        return (Site)list.get(0);
    }

    public boolean doDelete(Session session, Long id) {
        try {
            return this.doDelete(session, (Site)session.get(Site.class, (Serializable)id));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not delete Site with id [%s]", id), e);
        }
    }

    public boolean doDelete(Session session, Site site) {
        try {
            if (site == null) {
                return false;
            }
            if (!SiteUtil.isGlobal(site)) {
                TreeSet<Long> existingSimilarSites = new TreeSet<Long>(new SimilarSiteUtil().doGetSimilarSites(session, site.getId()));
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("Existing similars [%s]", existingSimilarSites));
                }
                Site globalExisting = this.getGlobalSiteForTheseSites(session, existingSimilarSites);
                this.doDelete(session, globalExisting);
            }
            List<Modeler> models = new ModelerUtil().getModelersForSite(session, site.getId());
            for (Modeler modeler : models) {
                new ModelerUtil().doDelete(session, modeler);
            }
            this.doDeleteFromSimilars(session, site.getId());
            session.delete((Object)site);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not delete Site  [%s]", site), e);
        }
    }

    static synchronized boolean isGlobal(Site site) {
        return "global".equalsIgnoreCase(site.getOwnerId());
    }

    public int doDeleteFromSimilars(Session session, Long id) {
        SQLQuery q = session.createSQLQuery(_DELETE_FROM_SIMILARS);
        q.setParameter("siteId", (Object)id);
        return q.executeUpdate();
    }
}

