/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import gr.i2s.fishgrowth.model.SimilarSite;
import java.util.List;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimilarSiteUtil
extends BaseUtil {
    private static final String _GET_ALL = "SELECT DISTINCT s.similarId FROM SimilarSite s WHERE siteId=:siteId AND grade>0 ORDER BY s.similarId ASC";
    private static final String _GET_ALL_BUT_ME = "SELECT DISTINCT s.similarId FROM SimilarSite s WHERE siteId=:siteId AND  similarId<>:siteId AND grade>0 ORDER BY s.similarId ASC";
    private static final String _DELETE_ALL = "DELETE FROM SimilarSite WHERE siteId=:siteId OR similarSiteId=:siteId";
    private static final String _DELETE_KEY = "DELETE FROM SimilarSite WHERE siteId=:siteId AND similarId=:similarId";
    private static final String _GET_GLOBAL = "SELECT DISTINCT s.similarId FROM SimilarSite s WHERE siteId=:siteId AND grade=-1";
    private static final Logger logger = LoggerFactory.getLogger(SimilarSiteUtil.class);

    public SimilarSite add(SimilarSite entity) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.save((Object)entity);
            session.flush();
            session.getTransaction().commit();
            SimilarSite similarSite = entity;
            return similarSite;
        }
        catch (Exception e) {
            logger.info(String.format("Could not add similar sites [%s]", entity), (Throwable)e);
            throw new Exception(String.format("Could not add similar sites [%s]", entity), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public List<Long> getSimilarSites(Long siteId) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            List<Long> list = this.getSimilarSites(session, siteId);
            session.getTransaction().commit();
            List<Long> list2 = list;
            return list2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not retrieve similar sites for siteid [%s]", siteId), (Throwable)e);
            throw new Exception(String.format("Could not retrieve similar sites for siteid [%s]", siteId), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public List<Long> getSimilarSitesExcludingMe(Long siteId) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            List<Long> list = this.getSimilarSitesExcludingMe(session, siteId);
            session.getTransaction().commit();
            List<Long> list2 = list;
            return list2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not retrieve similar sites exc me for siteid [%s]", siteId), (Throwable)e);
            throw new Exception(String.format("Could not retrieve similar sites exc me for siteid [%s]", siteId), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public boolean delete(Long siteId) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            NativeQuery q = session.createSQLQuery(_DELETE_ALL).setParameter("siteId", (Object)siteId);
            q.executeUpdate();
            session.flush();
            session.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete similar sites for siteid [%s]", siteId), (Throwable)e);
            throw new Exception(String.format("Could not delete similar sites for siteid [%s]", siteId), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public boolean delete(Long siteId, Long similarId) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            this.delete(session, siteId, similarId);
            session.flush();
            session.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete similar sites for siteid [%s] similarid [%s]", siteId, similarId), (Throwable)e);
            throw new Exception(String.format("Could not delete similar sites for siteid [%s] similarid [%s]", siteId, similarId), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public void delete(Session session, Long siteId, Long similarId) {
        NativeQuery q = session.createSQLQuery(_DELETE_KEY).setParameter("siteId", (Object)siteId).setParameter("similarId", (Object)similarId);
        q.executeUpdate();
    }

    public List<Long> getSimilarSitesExcludingMe(Session session, Long siteId) {
        NativeQuery q = session.createSQLQuery(_GET_ALL_BUT_ME).addScalar("similarId", (Type)LongType.INSTANCE).setParameter("siteId", (Object)siteId);
        List list = q.list();
        return list;
    }

    public List<Long> getSimilarSites(Session session, Long siteId) {
        NativeQuery q = session.createSQLQuery(_GET_ALL).addScalar("similarId", (Type)LongType.INSTANCE).setParameter("siteId", (Object)siteId);
        List list = q.list();
        return list;
    }

    public Long getGlobal(Session session, Long siteId) {
        NativeQuery q = session.createSQLQuery(_GET_GLOBAL).addScalar("similarId", (Type)LongType.INSTANCE).setParameter("siteId", (Object)siteId);
        List list = q.list();
        return list.isEmpty() ? null : (Long)list.get(0);
    }
}

