/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.calc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import gr.i2s.fishgrowth.Simulator.Executor;
import gr.i2s.fishgrowth.model.Fcr;
import gr.i2s.fishgrowth.model.ModelerFull;
import gr.i2s.fishgrowth.model.Mortality;
import gr.i2s.fishgrowth.model.Scenario;
import gr.i2s.fishgrowth.model.Sfr;
import gr.i2s.fishgrowth.model.Site;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.data.simulfishgrowthdata.api.base.FcrUtil;
import org.gcube.data.simulfishgrowthdata.api.base.ModelerFullUtil;
import org.gcube.data.simulfishgrowthdata.api.base.MortalityUtil;
import org.gcube.data.simulfishgrowthdata.api.base.ScenarioUtil;
import org.gcube.data.simulfishgrowthdata.api.base.SfrUtil;
import org.gcube.data.simulfishgrowthdata.api.base.SiteUtil;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScenarioExecutor
extends Executor {
    private static final Logger logger = LoggerFactory.getLogger(ScenarioExecutor.class);
    private boolean doSave = true;
    protected Session mSession = null;

    public ScenarioExecutor(Scenario scenario) {
        super(scenario);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("ctor", new Object[0]));
        }
    }

    public ScenarioExecutor(Session session, Scenario scenario) {
        super(scenario);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("ctor", new Object[0]));
        }
        this.mSession = session;
    }

    public ScenarioExecutor setDoSave(boolean doSave) {
        this.doSave = doSave;
        return this;
    }

    protected void beforeRun() {
        long start = System.currentTimeMillis();
        try {
            this.loadModelTemperature();
            this.makeTemperatureTable();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("temperature table [%s]", this.temperatureTable));
            }
            ArrayList<Fcr> fcrs = new ArrayList<Fcr>();
            this.loadFcrs(fcrs);
            this.adjustFcrs(fcrs);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("fcr table [%s]", this.fcrTable));
            }
            ArrayList<Sfr> sfrs = new ArrayList<Sfr>();
            this.loadSfrs(sfrs);
            this.adjustSfrs(sfrs);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("sfr table [%s]", this.sfrTable));
            }
            ArrayList<Mortality> mortalities = new ArrayList<Mortality>();
            this.loadMortalities(mortalities);
            this.adjustMortalities(mortalities);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("mortality table [%s]", this.mortalityTable));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem on beforeRun", e);
        }
        long duration = System.currentTimeMillis() - start;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("preparation took [%s] ms", duration));
        }
    }

    protected void adjustMortalities(List<Mortality> mortalities) {
        mortalities = this.mortalityByTempWeight.sortedCopy(mortalities);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("mortality list from db sorted [%s]", mortalities));
        }
        double lastLimit = 0.0;
        double prevMab = Double.MAX_VALUE;
        int curTemp = -1;
        TreeRangeMap tempColumn = null;
        for (Mortality mortality : mortalities) {
            if (mortality.getTemperature() != curTemp) {
                if (tempColumn != null) {
                    if (lastLimit > 0.0) {
                        tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
                    }
                    this.mortalityTable.put(curTemp, tempColumn);
                }
                curTemp = mortality.getTemperature();
                tempColumn = TreeRangeMap.create();
                prevMab = Double.MAX_VALUE;
            }
            double mab = mortality.getFromWeight();
            tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab)), (Object)mortality.getValue());
            lastLimit = mab;
            prevMab = mab;
        }
        if (tempColumn != null) {
            if (lastLimit > 0.0) {
                tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
            }
            this.mortalityTable.put(curTemp, tempColumn);
        }
    }

    protected void adjustSfrs(List<Sfr> sfrs) {
        sfrs = this.sfrByTempWeight.sortedCopy(sfrs);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("sfr list from db sorted [%s]", sfrs));
        }
        double lastLimit = 0.0;
        double prevMab = Double.MAX_VALUE;
        int curTemp = -1;
        TreeRangeMap tempColumn = null;
        for (Sfr sfr : sfrs) {
            if (sfr.getTemperature() != curTemp) {
                if (tempColumn != null) {
                    if (lastLimit > 0.0) {
                        tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
                    }
                    this.sfrTable.put(curTemp, tempColumn);
                }
                curTemp = sfr.getTemperature();
                tempColumn = TreeRangeMap.create();
                prevMab = Double.MAX_VALUE;
            }
            double mab = sfr.getFromWeight();
            tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab)), (Object)sfr.getValue());
            lastLimit = mab;
            prevMab = mab;
        }
        if (tempColumn != null) {
            if (lastLimit > 0.0) {
                tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
            }
            this.sfrTable.put(curTemp, tempColumn);
        }
    }

    protected void adjustFcrs(List<Fcr> fcrs) {
        fcrs = this.fcrByTempWeight.sortedCopy(fcrs);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("fcr list from db sorted [%s]", fcrs));
        }
        double lastLimit = 0.0;
        double prevMab = Double.MAX_VALUE;
        int curTemp = -1;
        TreeRangeMap tempColumn = null;
        for (Fcr fcr : fcrs) {
            if (fcr.getTemperature() != curTemp) {
                if (tempColumn != null) {
                    if (lastLimit > 0.0) {
                        tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
                    }
                    this.fcrTable.put(curTemp, tempColumn);
                }
                curTemp = fcr.getTemperature();
                tempColumn = TreeRangeMap.create();
                prevMab = Double.MAX_VALUE;
            }
            double mab = fcr.getFromWeight();
            tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab)), (Object)fcr.getValue());
            lastLimit = mab;
            prevMab = mab;
        }
        if (tempColumn != null) {
            if (lastLimit > 0.0) {
                tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
            }
            this.fcrTable.put(curTemp, tempColumn);
        }
    }

    protected void makeTemperatureTable() {
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(this.mScenario.getStartDate());
        startDate.set(10, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(this.mScenario.getTargetDate());
        endDate.set(10, 0);
        endDate.set(12, 0);
        endDate.set(13, 0);
        endDate.set(14, 0);
        Calendar curDate = startDate;
        while (!curDate.after(endDate)) {
            int month = curDate.get(2) + 1;
            int dayMonth = curDate.get(5);
            int middle = month == 2 ? 14 : 15;
            int idx = 2 * month - (dayMonth > middle ? 0 : 1) - 1;
            this.temperatureTable.put(curDate.getTimeInMillis(), this.modelTemperature[idx]);
            curDate.add(5, 1);
        }
    }

    protected void loadModelTemperature() throws Exception {
        ModelerFull modeler = this.mSession == null ? new ModelerFullUtil().getModelerFull(this.mScenario.getModelerId()) : new ModelerFullUtil().getModelerFull(this.mSession, this.mScenario.getModelerId());
        Site entity = this.mSession == null ? new SiteUtil().getSite(modeler.getSiteId()) : new SiteUtil().getSite(this.mSession, modeler.getSiteId());
        this.modelTemperature[0] = entity.getPeriodJanA();
        this.modelTemperature[1] = entity.getPeriodJanB();
        this.modelTemperature[2] = entity.getPeriodFebA();
        this.modelTemperature[3] = entity.getPeriodFebB();
        this.modelTemperature[4] = entity.getPeriodMarA();
        this.modelTemperature[5] = entity.getPeriodMarB();
        this.modelTemperature[6] = entity.getPeriodAprA();
        this.modelTemperature[7] = entity.getPeriodAprB();
        this.modelTemperature[8] = entity.getPeriodMayA();
        this.modelTemperature[9] = entity.getPeriodMayB();
        this.modelTemperature[10] = entity.getPeriodJunA();
        this.modelTemperature[11] = entity.getPeriodJunB();
        this.modelTemperature[12] = entity.getPeriodJulA();
        this.modelTemperature[13] = entity.getPeriodJulB();
        this.modelTemperature[14] = entity.getPeriodAugA();
        this.modelTemperature[15] = entity.getPeriodAugB();
        this.modelTemperature[16] = entity.getPeriodSepA();
        this.modelTemperature[17] = entity.getPeriodSepB();
        this.modelTemperature[18] = entity.getPeriodOctA();
        this.modelTemperature[19] = entity.getPeriodOctB();
        this.modelTemperature[20] = entity.getPeriodNovA();
        this.modelTemperature[21] = entity.getPeriodNovB();
        this.modelTemperature[22] = entity.getPeriodDecA();
        this.modelTemperature[23] = entity.getPeriodDecB();
    }

    protected void loadMortalities(List<Mortality> values) throws Exception {
        values.addAll(this.mSession == null ? new MortalityUtil().getMortalities(this.mScenario.getModelerId()) : new MortalityUtil().getMortalities(this.mSession, this.mScenario.getModelerId()));
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("mortalities list from db [%s]", values));
        }
    }

    protected void loadSfrs(List<Sfr> values) throws Exception {
        values.addAll(this.mSession == null ? new SfrUtil().getSfrs(this.mScenario.getModelerId()) : new SfrUtil().getSfrs(this.mSession, this.mScenario.getModelerId()));
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("sfr list from db [%s]", values));
        }
    }

    protected void loadFcrs(List<Fcr> values) throws Exception {
        values.addAll(this.mSession == null ? new FcrUtil().getFcrs(this.mScenario.getModelerId()) : new FcrUtil().getFcrs(this.mSession, this.mScenario.getModelerId()));
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("fcr list from db [%s]", values));
        }
    }

    protected void afterRun() {
        if (this.doSave) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("updating [%s]", this.mScenario));
            }
            try {
                if (this.mSession == null) {
                    new ScenarioUtil().update(this.mScenario);
                } else {
                    new ScenarioUtil().update(this.mSession, this.mScenario);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Problem on afterRun", e);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).toString();
    }
}

