/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import gr.i2s.fishgrowth.model.WeightLimit;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.gcube.data.simulfishgrowthdata.util.ExcelReader;
import org.gcube.data.simulfishgrowthdata.util.Utils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelLimitsReader
extends ExcelReader {
    private static final Logger logger = LoggerFactory.getLogger(ExcelLimitsReader.class);
    int fcrIdx = 0;
    int sfrIdx = 1;
    int sgrIdx = 2;
    int mortalityIdx = 3;
    int headersCount = 1;

    protected ExcelLimitsReader() {
    }

    @Override
    protected void importWorkbook(Session session, long simulModelId, String uploadSource, Workbook workbook) {
        Sheet sheet = workbook.getSheetAt(0);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Sheet 0 %s", sheet));
        }
        HashMap<Integer, Integer> idxToKind = new HashMap<Integer, Integer>();
        idxToKind.put(this.fcrIdx, 1);
        idxToKind.put(this.sfrIdx, 2);
        idxToKind.put(this.sgrIdx, 3);
        idxToKind.put(this.mortalityIdx, 4);
        int rowcnt = 0;
        for (Row row : sheet) {
            logger.debug(String.format("Row [%s] ------------------------------------------------------", ++rowcnt));
            if (rowcnt <= this.headersCount) {
                logger.debug(String.format("Row [%s] is header (%s row are headers)", rowcnt, this.headersCount));
                continue;
            }
            for (Cell cell : row) {
                int colIdx = cell.getColumnIndex();
                if (!idxToKind.containsKey(colIdx)) {
                    logger.trace(String.format("Bypassing column [%s] as it isnt mapped", colIdx));
                    continue;
                }
                if (cell.getCellTypeEnum() == CellType.BLANK) continue;
                WeightLimit data = new WeightLimit();
                data.setSimulModelId(simulModelId);
                data.setUploadSource(new Utils().limitLength(uploadSource, 99));
                data.setKpiKind(((Integer)idxToKind.get(colIdx)).intValue());
                data.setToWeight(cell.getNumericCellValue());
                logger.trace(String.format("Inserting from cell at row[%s]col[%s] data [%s]", rowcnt, colIdx, data));
                session.save((Object)data);
            }
        }
    }
}

