/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import com.google.gson.Gson;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.gcube.data.simulfishgrowthdata.util.SocialNetworkingExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostMessageExecutor
extends SocialNetworkingExecutor {
    static final Logger logger = LoggerFactory.getLogger(PostMessageExecutor.class);
    Message mMessage = new Message();

    public PostMessageExecutor(String endpoint) {
        super(endpoint);
    }

    public PostMessageExecutor setText(String text) {
        this.mMessage.text = text;
        return this;
    }

    public PostMessageExecutor setPreviewDescription(String previewDescription) {
        this.mMessage.preview_description = previewDescription;
        return this;
    }

    public PostMessageExecutor setPreviewTitle(String previewTitle) {
        this.mMessage.preview_title = previewTitle;
        return this;
    }

    public PostMessageExecutor setEnableNotification(boolean enableNotification) {
        this.mMessage.enable_notification = enableNotification;
        return this;
    }

    @Override
    protected HttpUriRequest createRequest(URI uri) {
        HttpPost request = new HttpPost(uri);
        return request;
    }

    @Override
    protected String makeUri() {
        return this.mEndpoint + "/2/posts/write-post-user";
    }

    @Override
    protected void prepareRequest(HttpUriRequest request) {
        String messageJson = new Gson().toJson((Object)this.mMessage);
        if (logger.isTraceEnabled()) {
            logger.trace("posting ~~" + messageJson + "~~");
        }
        StringEntity entity = new StringEntity(messageJson, ContentType.APPLICATION_JSON);
        ((HttpPost)request).setEntity((HttpEntity)entity);
    }

    @Override
    protected SocialNetworkingExecutor.Response processOutput(String output) throws Exception {
        SocialNetworkingExecutor.Response response = super.processOutput(output);
        if (!response.isSuccess()) {
            throw new Exception(response.message);
        }
        return response;
    }

    static class Message {
        public String text;
        public String preview_title;
        public String preview_description;
        public boolean enable_notification;

        Message() {
        }
    }
}

