/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import gr.i2s.fishgrowth.model.Site;
import gr.i2s.fishgrowth.model.SiteFull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteFullUtil
extends BaseUtil {
    String additionalSimilarityConstraint = null;
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.SiteFull s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final String _GET_ALL_ON_OWNERID_COUNT = "SELECT count(*) FROM gr.i2s.fishgrowth.model.SiteFull s WHERE s.ownerId = :ownerid";
    private static final String _GET_SIMILAR = "SELECT id FROM gr.i2s.fishgrowth.model.SiteFull s WHERE  (%s) AND  id <> :id AND  ownerId <> :global AND  s.periodJanA BETWEEN :janAFrom AND :janATo AND  s.periodJanB BETWEEN :janBFrom AND :janBTo AND  s.periodFebA BETWEEN :febAFrom AND :febATo AND  s.periodFebB BETWEEN :febBFrom AND :febBTo AND  s.periodMarA BETWEEN :marAFrom AND :marATo AND  s.periodMarB BETWEEN :marBFrom AND :marBTo AND  s.periodAprA BETWEEN :aprAFrom AND :aprATo AND  s.periodAprB BETWEEN :aprBFrom AND :aprBTo AND  s.periodMayA BETWEEN :mayAFrom AND :mayATo AND  s.periodMayB BETWEEN :mayBFrom AND :mayBTo AND  s.periodJunA BETWEEN :junAFrom AND :junATo AND  s.periodJunB BETWEEN :junBFrom AND :junBTo AND  s.periodJulA BETWEEN :julAFrom AND :julATo AND  s.periodJulB BETWEEN :julBFrom AND :julBTo AND  s.periodAugA BETWEEN :augAFrom AND :augATo AND  s.periodAugB BETWEEN :augBFrom AND :augBTo AND  s.periodSepA BETWEEN :sepAFrom AND :sepATo AND  s.periodSepB BETWEEN :sepBFrom AND :sepBTo AND  s.periodOctA BETWEEN :octAFrom AND :octATo AND  s.periodOctB BETWEEN :octBFrom AND :octBTo AND  s.periodNovA BETWEEN :novAFrom AND :novATo AND  s.periodNovB BETWEEN :novBFrom AND :novBTo AND  s.periodDecA BETWEEN :decAFrom AND :decATo AND  s.periodDecB BETWEEN :decBFrom AND :decBTo AND  s.periodYear BETWEEN :yearFrom AND :yearTo AND  s.oxygenPeriodJanA BETWEEN :oxygenjanAFrom AND :oxygenjanATo AND  s.oxygenPeriodJanB BETWEEN :oxygenjanBFrom AND :oxygenjanBTo AND  s.oxygenPeriodFebA BETWEEN :oxygenfebAFrom AND :oxygenfebATo AND  s.oxygenPeriodFebB BETWEEN :oxygenfebBFrom AND :oxygenfebBTo AND  s.oxygenPeriodMarA BETWEEN :oxygenmarAFrom AND :oxygenmarATo AND  s.oxygenPeriodMarB BETWEEN :oxygenmarBFrom AND :oxygenmarBTo AND  s.oxygenPeriodAprA BETWEEN :oxygenaprAFrom AND :oxygenaprATo AND  s.oxygenPeriodAprB BETWEEN :oxygenaprBFrom AND :oxygenaprBTo AND  s.oxygenPeriodMayA BETWEEN :oxygenmayAFrom AND :oxygenmayATo AND  s.oxygenPeriodMayB BETWEEN :oxygenmayBFrom AND :oxygenmayBTo AND  s.oxygenPeriodJunA BETWEEN :oxygenjunAFrom AND :oxygenjunATo AND  s.oxygenPeriodJunB BETWEEN :oxygenjunBFrom AND :oxygenjunBTo AND  s.oxygenPeriodJulA BETWEEN :oxygenjulAFrom AND :oxygenjulATo AND  s.oxygenPeriodJulB BETWEEN :oxygenjulBFrom AND :oxygenjulBTo AND  s.oxygenPeriodAugA BETWEEN :oxygenaugAFrom AND :oxygenaugATo AND  s.oxygenPeriodAugB BETWEEN :oxygenaugBFrom AND :oxygenaugBTo AND  s.oxygenPeriodSepA BETWEEN :oxygensepAFrom AND :oxygensepATo AND  s.oxygenPeriodSepB BETWEEN :oxygensepBFrom AND :oxygensepBTo AND  s.oxygenPeriodOctA BETWEEN :oxygenoctAFrom AND :oxygenoctATo AND  s.oxygenPeriodOctB BETWEEN :oxygenoctBFrom AND :oxygenoctBTo AND  s.oxygenPeriodNovA BETWEEN :oxygennovAFrom AND :oxygennovATo AND  s.oxygenPeriodNovB BETWEEN :oxygennovBFrom AND :oxygennovBTo AND  s.oxygenPeriodDecA BETWEEN :oxygendecAFrom AND :oxygendecATo AND  s.oxygenPeriodDecB BETWEEN :oxygendecBFrom AND :oxygendecBTo AND  s.oxygenPeriodYear BETWEEN :oxygenyearFrom AND :oxygenyearTo  ORDER BY id ASC";
    private static final Logger logger = LoggerFactory.getLogger(SiteFullUtil.class);

    public SiteFullUtil setAdditionalSimilarityConstraint(String additionalSimilarityConstraint) {
        this.additionalSimilarityConstraint = additionalSimilarityConstraint;
        return this;
    }

    public SiteFull getSiteFull(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            SiteFull siteFull = (SiteFull)session.get(SiteFull.class, (Serializable)id);
            session.getTransaction().commit();
            SiteFull siteFull2 = siteFull;
            return siteFull2;
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full site for [%s]", id), (Throwable)e);
            throw new Exception("not found");
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public List<SiteFull> getSiteFulls(String ownerId, Integer start, Integer end) throws Exception {
        List list;
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("reading %s for %s start %s end %s", "SiteFull", ownerId, start, end));
        }
        Session session = null;
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("start getSiteFulls", new Object[0]));
            }
            session = HibernateUtil.openSession();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("session [%s]", session));
            }
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            if (start > 0) {
                q.setFirstResult(start.intValue());
            }
            if (end > 0) {
                if (end < start) {
                    end = start + 1;
                }
                q.setMaxResults(end - start);
            }
            List list2 = q.list();
            session.getTransaction().commit();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("return SiteFulls %s", list2));
            }
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve full sites for ownerid[%s]", ownerId), (Throwable)e);
                throw new Exception("not found");
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public List<SiteFull> getSiteFulls(String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("start getSiteFulls", new Object[0]));
            }
            session = HibernateUtil.openSession();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("session [%s]", session));
            }
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("return SiteFulls %s", list2));
            }
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve full sites for ownerid[%s]", ownerId), (Throwable)e);
                throw new Exception("not found");
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public int getSiteFullCount(String ownerId) throws Exception {
        int n;
        Session session = null;
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("start getSiteFulls", new Object[0]));
            }
            session = HibernateUtil.openSession();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("session [%s]", session));
            }
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID_COUNT).setParameter("ownerid", (Object)ownerId);
            Number count = (Number)q.uniqueResult();
            session.getTransaction().commit();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("return count %s", count));
            }
            n = count.intValue();
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve full site count for ownerid[%s]", ownerId), (Throwable)e);
                throw new Exception("not found");
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return n;
    }

    public List<Long> getSiteFullSimilar(Session session, Site site, Integer dtemp, Integer dAnnualTemp, Integer doxygen) {
        List<Long> list = new ArrayList<Long>();
        if (site == null) {
            return list;
        }
        String additionalConstraint = this.additionalSimilarityConstraint;
        if (additionalConstraint == null || additionalConstraint.isEmpty()) {
            additionalConstraint = "1=1";
        }
        Integer dAnnualOxygen = 1000;
        Query q = session.createQuery(String.format(_GET_SIMILAR, additionalConstraint)).setParameter("id", (Object)site.getId()).setParameter("global", (Object)"global").setParameter("janAFrom", (Object)(site.getPeriodJanA() - dtemp)).setParameter("janATo", (Object)(site.getPeriodJanA() + dtemp)).setParameter("janBFrom", (Object)(site.getPeriodJanB() - dtemp)).setParameter("janBTo", (Object)(site.getPeriodJanB() + dtemp)).setParameter("febAFrom", (Object)(site.getPeriodFebA() - dtemp)).setParameter("febATo", (Object)(site.getPeriodFebA() + dtemp)).setParameter("febBFrom", (Object)(site.getPeriodFebB() - dtemp)).setParameter("febBTo", (Object)(site.getPeriodFebB() + dtemp)).setParameter("marAFrom", (Object)(site.getPeriodMarA() - dtemp)).setParameter("marATo", (Object)(site.getPeriodMarA() + dtemp)).setParameter("marBFrom", (Object)(site.getPeriodMarB() - dtemp)).setParameter("marBTo", (Object)(site.getPeriodMarB() + dtemp)).setParameter("aprAFrom", (Object)(site.getPeriodAprA() - dtemp)).setParameter("aprATo", (Object)(site.getPeriodAprA() + dtemp)).setParameter("aprBFrom", (Object)(site.getPeriodAprB() - dtemp)).setParameter("aprBTo", (Object)(site.getPeriodAprB() + dtemp)).setParameter("mayAFrom", (Object)(site.getPeriodMayA() - dtemp)).setParameter("mayATo", (Object)(site.getPeriodMayA() + dtemp)).setParameter("mayBFrom", (Object)(site.getPeriodMayB() - dtemp)).setParameter("mayBTo", (Object)(site.getPeriodMayB() + dtemp)).setParameter("junAFrom", (Object)(site.getPeriodJunA() - dtemp)).setParameter("junATo", (Object)(site.getPeriodJunA() + dtemp)).setParameter("junBFrom", (Object)(site.getPeriodJunB() - dtemp)).setParameter("junBTo", (Object)(site.getPeriodJunB() + dtemp)).setParameter("julAFrom", (Object)(site.getPeriodJulA() - dtemp)).setParameter("julATo", (Object)(site.getPeriodJulA() + dtemp)).setParameter("julBFrom", (Object)(site.getPeriodJulB() - dtemp)).setParameter("julBTo", (Object)(site.getPeriodJulB() + dtemp)).setParameter("augAFrom", (Object)(site.getPeriodAugA() - dtemp)).setParameter("augATo", (Object)(site.getPeriodAugA() + dtemp)).setParameter("augBFrom", (Object)(site.getPeriodAugB() - dtemp)).setParameter("augBTo", (Object)(site.getPeriodAugB() + dtemp)).setParameter("sepAFrom", (Object)(site.getPeriodSepA() - dtemp)).setParameter("sepATo", (Object)(site.getPeriodSepA() + dtemp)).setParameter("sepBFrom", (Object)(site.getPeriodSepB() - dtemp)).setParameter("sepBTo", (Object)(site.getPeriodSepB() + dtemp)).setParameter("octAFrom", (Object)(site.getPeriodOctA() - dtemp)).setParameter("octATo", (Object)(site.getPeriodOctA() + dtemp)).setParameter("octBFrom", (Object)(site.getPeriodOctB() - dtemp)).setParameter("octBTo", (Object)(site.getPeriodOctB() + dtemp)).setParameter("novAFrom", (Object)(site.getPeriodNovA() - dtemp)).setParameter("novATo", (Object)(site.getPeriodNovA() + dtemp)).setParameter("novBFrom", (Object)(site.getPeriodNovB() - dtemp)).setParameter("novBTo", (Object)(site.getPeriodNovB() + dtemp)).setParameter("decAFrom", (Object)(site.getPeriodDecA() - dtemp)).setParameter("decATo", (Object)(site.getPeriodDecA() + dtemp)).setParameter("decBFrom", (Object)(site.getPeriodDecB() - dtemp)).setParameter("decBTo", (Object)(site.getPeriodDecB() + dtemp)).setParameter("yearFrom", (Object)(site.getPeriodYear() - dAnnualTemp)).setParameter("yearTo", (Object)(site.getPeriodYear() + dAnnualTemp)).setParameter("oxygenjanAFrom", (Object)(site.getOxygenPeriodJanA() - doxygen)).setParameter("oxygenjanATo", (Object)(site.getOxygenPeriodJanA() + doxygen)).setParameter("oxygenjanBFrom", (Object)(site.getOxygenPeriodJanB() - doxygen)).setParameter("oxygenjanBTo", (Object)(site.getOxygenPeriodJanB() + doxygen)).setParameter("oxygenfebAFrom", (Object)(site.getOxygenPeriodFebA() - doxygen)).setParameter("oxygenfebATo", (Object)(site.getOxygenPeriodFebA() + doxygen)).setParameter("oxygenfebBFrom", (Object)(site.getOxygenPeriodFebB() - doxygen)).setParameter("oxygenfebBTo", (Object)(site.getOxygenPeriodFebB() + doxygen)).setParameter("oxygenmarAFrom", (Object)(site.getOxygenPeriodMarA() - doxygen)).setParameter("oxygenmarATo", (Object)(site.getOxygenPeriodMarA() + doxygen)).setParameter("oxygenmarBFrom", (Object)(site.getOxygenPeriodMarB() - doxygen)).setParameter("oxygenmarBTo", (Object)(site.getOxygenPeriodMarB() + doxygen)).setParameter("oxygenaprAFrom", (Object)(site.getOxygenPeriodAprA() - doxygen)).setParameter("oxygenaprATo", (Object)(site.getOxygenPeriodAprA() + doxygen)).setParameter("oxygenaprBFrom", (Object)(site.getOxygenPeriodAprB() - doxygen)).setParameter("oxygenaprBTo", (Object)(site.getOxygenPeriodAprB() + doxygen)).setParameter("oxygenmayAFrom", (Object)(site.getOxygenPeriodMayA() - doxygen)).setParameter("oxygenmayATo", (Object)(site.getOxygenPeriodMayA() + doxygen)).setParameter("oxygenmayBFrom", (Object)(site.getOxygenPeriodMayB() - doxygen)).setParameter("oxygenmayBTo", (Object)(site.getOxygenPeriodMayB() + doxygen)).setParameter("oxygenjunAFrom", (Object)(site.getOxygenPeriodJunA() - doxygen)).setParameter("oxygenjunATo", (Object)(site.getOxygenPeriodJunA() + doxygen)).setParameter("oxygenjunBFrom", (Object)(site.getOxygenPeriodJunB() - doxygen)).setParameter("oxygenjunBTo", (Object)(site.getOxygenPeriodJunB() + doxygen)).setParameter("oxygenjulAFrom", (Object)(site.getOxygenPeriodJulA() - doxygen)).setParameter("oxygenjulATo", (Object)(site.getOxygenPeriodJulA() + doxygen)).setParameter("oxygenjulBFrom", (Object)(site.getOxygenPeriodJulB() - doxygen)).setParameter("oxygenjulBTo", (Object)(site.getOxygenPeriodJulB() + doxygen)).setParameter("oxygenaugAFrom", (Object)(site.getOxygenPeriodAugA() - doxygen)).setParameter("oxygenaugATo", (Object)(site.getOxygenPeriodAugA() + doxygen)).setParameter("oxygenaugBFrom", (Object)(site.getOxygenPeriodAugB() - doxygen)).setParameter("oxygenaugBTo", (Object)(site.getOxygenPeriodAugB() + doxygen)).setParameter("oxygensepAFrom", (Object)(site.getOxygenPeriodSepA() - doxygen)).setParameter("oxygensepATo", (Object)(site.getOxygenPeriodSepA() + doxygen)).setParameter("oxygensepBFrom", (Object)(site.getOxygenPeriodSepB() - doxygen)).setParameter("oxygensepBTo", (Object)(site.getOxygenPeriodSepB() + doxygen)).setParameter("oxygenoctAFrom", (Object)(site.getOxygenPeriodOctA() - doxygen)).setParameter("oxygenoctATo", (Object)(site.getOxygenPeriodOctA() + doxygen)).setParameter("oxygenoctBFrom", (Object)(site.getOxygenPeriodOctB() - doxygen)).setParameter("oxygenoctBTo", (Object)(site.getOxygenPeriodOctB() + doxygen)).setParameter("oxygennovAFrom", (Object)(site.getOxygenPeriodNovA() - doxygen)).setParameter("oxygennovATo", (Object)(site.getOxygenPeriodNovA() + doxygen)).setParameter("oxygennovBFrom", (Object)(site.getOxygenPeriodNovB() - doxygen)).setParameter("oxygennovBTo", (Object)(site.getOxygenPeriodNovB() + doxygen)).setParameter("oxygendecAFrom", (Object)(site.getOxygenPeriodDecA() - doxygen)).setParameter("oxygendecATo", (Object)(site.getOxygenPeriodDecA() + doxygen)).setParameter("oxygendecBFrom", (Object)(site.getOxygenPeriodDecB() - doxygen)).setParameter("oxygendecBTo", (Object)(site.getOxygenPeriodDecB() + doxygen)).setParameter("oxygenyearFrom", (Object)(site.getOxygenPeriodYear() - dAnnualOxygen)).setParameter("oxygenyearTo", (Object)(site.getOxygenPeriodYear() + dAnnualOxygen));
        list = q.list();
        return list;
    }
}

