/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Modeler;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.FcrUtil;
import org.gcube.data.simulfishgrowthdata.api.MortalityUtil;
import org.gcube.data.simulfishgrowthdata.api.SfrUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/Modeler")
public class ModelerUtil {
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Modeler s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final Logger logger = LoggerFactory.getLogger(ModelerUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/json"})
    public Response add(Modeler modeler) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.save((Object)modeler);
            session.flush();
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)modeler.getId()).build();
            return response;
        }
        catch (Exception e) {
            logger.error(String.format("Could not add modeler [%s]", modeler), (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    public Response update(Modeler modeler) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.update((Object)modeler);
            session.flush();
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)modeler).build();
            return response;
        }
        catch (Exception e) {
            logger.error(String.format("Could not update modeler [%s]", modeler), (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Modeler modeler = (Modeler)session.get(Modeler.class, (Serializable)id);
            if (modeler != null) {
                session.delete((Object)modeler);
                session.flush();
            }
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            return response;
        }
        catch (Exception e) {
            logger.error(String.format("Could not delete modeler [%s]", id), (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Modeler getModeler(@PathParam(value="id") Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Modeler modeler = (Modeler)session.get(Modeler.class, (Serializable)id);
            session.getTransaction().commit();
            Modeler modeler2 = modeler;
            return modeler2;
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve modeler [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<?> getModelers(@PathParam(value="ownerId") String ownerId, @QueryParam(value="statuses") List<Long> statuses) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getModelers", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            if (statuses != null && !statuses.isEmpty()) {
                ListIterator iter = list2.listIterator();
                while (iter.hasNext()) {
                    Modeler m = (Modeler)iter.next();
                    if (statuses.contains(m.getStatusId())) continue;
                    iter.remove();
                }
            }
            session.getTransaction().commit();
            logger.trace(String.format("return Modelers %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve modelers for [%s]", ownerId), (Throwable)e);
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    @DELETE
    @Path(value="/kpi/{id}")
    public void cleanKPIs(@PathParam(value="id") Long id) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("clearing KPIs for model %s", id));
        }
        new SfrUtil().deleteAll(id);
        new FcrUtil().deleteAll(id);
        new MortalityUtil().deleteAll(id);
    }
}

