/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Sfr;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/Sfr")
public class SfrUtil {
    private static final String _GET_ALL_ON_MODELER = "FROM gr.i2s.fishgrowth.model.Sfr s WHERE s.modelerId = :modelerId ORDER BY s.temperature ASC, fromWeight DESC";
    private static final String _DEL_ALL_ON_MODELER = "DELETE FROM gr.i2s.fishgrowth.model.Sfr s WHERE s.modelerId = :modelerId";
    private static final Logger logger = LoggerFactory.getLogger(SfrUtil.class);

    @GET
    @Path(value="/all")
    public List<Sfr> getSfrs(@PathParam(value="modelId") Long modelId) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_MODELER).setParameter("modelerId", (Object)modelId);
            List list = q.list();
            session.getTransaction().commit();
            List list2 = list;
            return list2;
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve sfr for modelid [%s]", modelId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{id}")
    public Response deleteAll(@PathParam(value="modelId") Long modelId) {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Query q = session.createQuery(_DEL_ALL_ON_MODELER).setParameter("modelerId", (Object)modelId);
            int count = q.executeUpdate();
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)count).build();
            return response;
        }
        catch (Exception e) {
            logger.error("Could not delete", (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }
}

