/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.calc;

import com.google.common.base.MoreObjects;
import gr.i2s.fishgrowth.Simulator.Executor;
import gr.i2s.fishgrowth.model.Scenario;
import java.text.SimpleDateFormat;
import org.gcube.data.simulfishgrowthdata.calc.ScenarioExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumptionScenarioExecutor
extends ScenarioExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ConsumptionScenarioExecutor.class);

    public ConsumptionScenarioExecutor(Scenario scenario) {
        super(scenario);
        this.setDoSave(false);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("ctor", new Object[0]));
        }
    }

    protected String processResults() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("processing results", new Object[0]));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/YY");
        String toRet = new String();
        String tableDaily = new String();
        String record = "{'day': '%s', 'bm':%s, 'fcre':%.2f, 'fcrb':%.2f, 'food':%s, 'bmdead':%s },";
        for (Executor.Daily daily : this.dailyResults) {
            String day = dateFormat.format(daily.date.getTime());
            String newDay = String.format(record, day, new Double((double)daily.fishcount.intValue() * daily.mab).intValue(), daily.fcrEcon, daily.fcrBiol, Math.round(daily.food / 1000.0), daily.deadBM.intValue());
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("adding day [%s]", newDay));
            }
            tableDaily = tableDaily + newDay;
        }
        toRet = String.format("{'daily':[%s]}", tableDaily);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("after processing results returning [%s]", toRet));
        }
        return toRet;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

