/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Site;
import gr.i2s.fishgrowth.model.SiteFull;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.SiteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/SiteFull")
public class SiteFullUtil
extends BaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(SiteFullUtil.class);

    @PUT
    @Consumes(value={"application/json"})
    public Response add(SiteFull siteFull) throws Exception {
        return new SiteUtil().add((Site)siteFull);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response update(SiteFull siteFull) throws Exception {
        return new SiteUtil().update(new Site((Site)siteFull));
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        return new SiteUtil().delete(id);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public SiteFull getSiteFull(@PathParam(value="id") Long id) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SiteFullUtil().getSiteFull(id);
        }
        catch (Exception e) {
            logger.error(String.format("Could not get site full [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/all/{ownerId}/{start}/{end}")
    public List<SiteFull> getSiteFulls(@PathParam(value="ownerId") String ownerId, @PathParam(value="start") Integer start, @PathParam(value="end") Integer end) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SiteFullUtil().getSiteFulls(ownerId, start, end);
        }
        catch (Exception e) {
            logger.error(String.format("Could not get site full for [%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<SiteFull> getSiteFulls(@PathParam(value="ownerId") String ownerId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SiteFullUtil().getSiteFulls(ownerId);
        }
        catch (Exception e) {
            logger.error(String.format("Could not get site full for [%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/count/{ownerId}")
    public int getSiteFullCount(@PathParam(value="ownerId") String ownerId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SiteFullUtil().getSiteFullCount(ownerId);
        }
        catch (Exception e) {
            logger.error(String.format("Could not get site full count for [%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/similar/{id}/{dtemp}")
    @Produces(value={"application/json"})
    public List<Long> getSiteFullSimilar(@PathParam(value="id") Long id, @PathParam(value="dtemp") Integer dtemp) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SiteFullUtil().getSiteFullSimilar(id, dtemp);
        }
        catch (Exception e) {
            logger.error(String.format("Could not get site full similar for [%s] dtemp [%s]", id, dtemp), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

