/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.calc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import gr.i2s.fishgrowth.Simulator.Executor;
import gr.i2s.fishgrowth.model.ModelerFull;
import gr.i2s.fishgrowth.model.Mortality;
import gr.i2s.fishgrowth.model.Scenario;
import gr.i2s.fishgrowth.model.Sfr;
import gr.i2s.fishgrowth.model.Site;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.data.simulfishgrowthdata.api.FcrUtil;
import org.gcube.data.simulfishgrowthdata.api.ModelerFullUtil;
import org.gcube.data.simulfishgrowthdata.api.MortalityUtil;
import org.gcube.data.simulfishgrowthdata.api.ScenarioUtil;
import org.gcube.data.simulfishgrowthdata.api.SfrUtil;
import org.gcube.data.simulfishgrowthdata.api.SiteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioExecutor
extends Executor {
    private static final Logger logger = LoggerFactory.getLogger(ScenarioExecutor.class);
    private boolean doSave = true;

    public ScenarioExecutor(Scenario scenario) {
        super(scenario);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("ctor", new Object[0]));
        }
    }

    public ScenarioExecutor setDoSave(boolean doSave) {
        this.doSave = doSave;
        return this;
    }

    protected void beforeRun() {
        super.beforeRun();
        long start = System.currentTimeMillis();
        try {
            ModelerFull modeler = new ModelerFullUtil().getModelerFull(Long.valueOf(this.mScenario.getModelerId()));
            Site entity = new SiteUtil().getSite(Long.valueOf(modeler.getSiteId()));
            this.modelTemperature[0] = entity.getPeriodJanA();
            this.modelTemperature[1] = entity.getPeriodJanB();
            this.modelTemperature[2] = entity.getPeriodFebA();
            this.modelTemperature[3] = entity.getPeriodFebB();
            this.modelTemperature[4] = entity.getPeriodMarA();
            this.modelTemperature[5] = entity.getPeriodMarB();
            this.modelTemperature[6] = entity.getPeriodAprA();
            this.modelTemperature[7] = entity.getPeriodAprB();
            this.modelTemperature[8] = entity.getPeriodMayA();
            this.modelTemperature[9] = entity.getPeriodMayB();
            this.modelTemperature[10] = entity.getPeriodJunA();
            this.modelTemperature[11] = entity.getPeriodJunB();
            this.modelTemperature[12] = entity.getPeriodJulA();
            this.modelTemperature[13] = entity.getPeriodJulB();
            this.modelTemperature[14] = entity.getPeriodAugA();
            this.modelTemperature[15] = entity.getPeriodAugB();
            this.modelTemperature[16] = entity.getPeriodSepA();
            this.modelTemperature[17] = entity.getPeriodSepB();
            this.modelTemperature[18] = entity.getPeriodOctA();
            this.modelTemperature[19] = entity.getPeriodOctB();
            this.modelTemperature[20] = entity.getPeriodNovA();
            this.modelTemperature[21] = entity.getPeriodNovB();
            this.modelTemperature[22] = entity.getPeriodDecA();
            this.modelTemperature[23] = entity.getPeriodDecB();
        }
        catch (Exception e) {
            logger.error("problem", (Throwable)e);
        }
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(this.mScenario.getStartDate());
        startDate.set(10, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(this.mScenario.getTargetDate());
        endDate.set(10, 0);
        endDate.set(12, 0);
        endDate.set(13, 0);
        endDate.set(14, 0);
        Calendar curDate = startDate;
        while (!curDate.after(endDate)) {
            int month = curDate.get(2) + 1;
            int dayMonth = curDate.get(5);
            int middle = month == 2 ? 14 : 15;
            int idx = 2 * month - (dayMonth > middle ? 0 : 1) - 1;
            this.temperatureTable.put(curDate.getTimeInMillis(), this.modelTemperature[idx]);
            curDate.add(5, 1);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("temperature table from db [%s]", this.temperatureTable));
        }
        List fcrs = new ArrayList();
        try {
            fcrs.addAll(new FcrUtil().getFcrs(Long.valueOf(this.mScenario.getModelerId())));
        }
        catch (Exception e) {
            logger.error("problem", (Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("fcr list from db [%s]", fcrs));
        }
        fcrs = this.fcrByTempWeight.sortedCopy(fcrs);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("fcr list from db sorted [%s]", fcrs));
        }
        double lastLimit = 0.0;
        double prevMab = Double.MAX_VALUE;
        int curTemp = -1;
        TreeRangeMap tempColumn = null;
        for (Object fcr : fcrs) {
            if (fcr.getTemperature() != curTemp) {
                if (tempColumn != null) {
                    if (lastLimit > 0.0) {
                        tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
                    }
                    this.fcrTable.put(curTemp, tempColumn);
                }
                curTemp = fcr.getTemperature();
                tempColumn = TreeRangeMap.create();
                prevMab = Double.MAX_VALUE;
            }
            double mab = fcr.getFromWeight();
            tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab)), (Object)fcr.getValue());
            lastLimit = mab;
            prevMab = mab;
        }
        if (tempColumn != null) {
            if (lastLimit > 0.0) {
                tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
            }
            this.fcrTable.put(curTemp, tempColumn);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("fcr table [%s]", this.fcrTable));
        }
        List sfrs = new ArrayList();
        try {
            sfrs.addAll(new SfrUtil().getSfrs(Long.valueOf(this.mScenario.getModelerId())));
        }
        catch (Exception e) {
            logger.error("problem", (Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("sfr list from db [%s]", sfrs));
        }
        sfrs = this.sfrByTempWeight.sortedCopy(sfrs);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("sfr list from db sorted [%s]", sfrs));
        }
        double lastLimit2 = 0.0;
        double prevMab2 = Double.MAX_VALUE;
        int curTemp2 = -1;
        TreeRangeMap tempColumn2 = null;
        for (Sfr sfr : sfrs) {
            if (sfr.getTemperature() != curTemp2) {
                if (tempColumn2 != null) {
                    if (lastLimit2 > 0.0) {
                        tempColumn2.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit2)), (Object)0.0);
                    }
                    this.sfrTable.put(curTemp2, tempColumn2);
                }
                curTemp2 = sfr.getTemperature();
                tempColumn2 = TreeRangeMap.create();
                prevMab2 = Double.MAX_VALUE;
            }
            double mab = sfr.getFromWeight();
            tempColumn2.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab2)), (Object)sfr.getValue());
            lastLimit2 = mab;
            prevMab2 = mab;
        }
        if (tempColumn2 != null) {
            if (lastLimit2 > 0.0) {
                tempColumn2.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit2)), (Object)0.0);
            }
            this.sfrTable.put(curTemp2, tempColumn2);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("sfr table [%s]", this.sfrTable));
        }
        List mortalities = new ArrayList();
        try {
            mortalities.addAll(new MortalityUtil().getMortalities(Long.valueOf(this.mScenario.getModelerId())));
        }
        catch (Exception e) {
            logger.error("problem", (Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("mortality list from db [%s]", mortalities));
        }
        mortalities = this.mortalityByTempWeight.sortedCopy(mortalities);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("mortality list from db sorted [%s]", mortalities));
        }
        double lastLimit3 = 0.0;
        double prevMab3 = Double.MAX_VALUE;
        int curTemp3 = -1;
        TreeRangeMap tempColumn3 = null;
        for (Mortality mortality : mortalities) {
            if (mortality.getTemperature() != curTemp3) {
                if (tempColumn3 != null) {
                    if (lastLimit3 > 0.0) {
                        tempColumn3.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit3)), (Object)0.0);
                    }
                    this.mortalityTable.put(curTemp3, tempColumn3);
                }
                curTemp3 = mortality.getTemperature();
                tempColumn3 = TreeRangeMap.create();
                prevMab3 = Double.MAX_VALUE;
            }
            double mab = mortality.getFromWeight();
            tempColumn3.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab3)), (Object)mortality.getValue());
            lastLimit3 = mab;
            prevMab3 = mab;
        }
        if (tempColumn3 != null) {
            if (lastLimit3 > 0.0) {
                tempColumn3.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit3)), (Object)0.0);
            }
            this.mortalityTable.put(curTemp3, tempColumn3);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("mortality table [%s]", this.mortalityTable));
        }
        long duration = System.currentTimeMillis() - start;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("preparation took [%s] ms", duration));
        }
    }

    protected void afterRun() {
        try {
            super.afterRun();
            if (this.doSave) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("updating [%s]", this.mScenario));
                }
                new ScenarioUtil().update(this.mScenario);
            }
        }
        catch (Exception e) {
            logger.error("problem", (Throwable)e);
        }
    }

    protected String processResults() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        String tableWeight = new String();
        String tableFCR = new String();
        String tableFood = new String();
        String recordWeight = "{c:[{v: \"%s\"}, {v: %.2f}]},";
        String recordFCR = "{c:[{v: \"%s\"}, {v: %.2f}, {v: %.2f}]},";
        String recordFood = "{c:[{v: \"%s-%s\"}, {v: %.2f}]},";
        int foodMonth = -1;
        int foodYear = -1;
        double foodCons = 0.0;
        for (Executor.Daily daily : this.dailyResults) {
            String day = dateFormat.format(daily.date.getTime());
            tableWeight = tableWeight + String.format(recordWeight, day, daily.mab);
            if (daily.fcrBiol > 0.0) {
                tableFCR = tableFCR + String.format(recordFCR, day, daily.fcrBiol, daily.fcrEcon);
            }
            if (foodMonth != daily.date.get(2) || foodYear != daily.date.get(1)) {
                if (foodCons > 0.0) {
                    tableFood = tableFood + String.format(recordFood, foodMonth + 1, foodYear, foodCons / 1000.0);
                }
                foodCons = 0.0;
                foodMonth = daily.date.get(2);
                foodYear = daily.date.get(1);
            }
            foodCons += daily.food.doubleValue();
        }
        if (foodCons > 0.0) {
            tableFood = tableFood + String.format(recordFood, foodMonth + 1, foodYear, foodCons / 1000.0);
        }
        return tableWeight + "gri2sbbridge" + tableFCR + "gri2sbbridge" + tableFood;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

