/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Site;
import gr.i2s.fishgrowth.model.Usage;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.BaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/Site")
public class SiteUtil
extends BaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(SiteUtil.class);

    @PUT
    @Consumes(value={"application/json"})
    public Response add(Site site) throws Exception {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.SiteUtil().add(site);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)site.getId()).build();
        }
        catch (Exception e) {
            logger.error(String.format("Could not add site [%s]", site), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response update(Site site) throws Exception {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.SiteUtil().update(site);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)site).build();
        }
        catch (Exception e) {
            logger.error(String.format("Could not update site [%s]", site), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.SiteUtil().delete(id);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            logger.error(String.format("Could not delete site [%s]", id), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Site getSite(@PathParam(value="id") Long id) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SiteUtil().getSite(id);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve site [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<Site> getSites(@PathParam(value="ownerId") String ownerId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SiteUtil().getSites(ownerId);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve sites for ownerid [%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/usage/{ownerId}")
    public List<Usage> getUsage(@PathParam(value="ownerId") String ownerId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SiteUtil().getUsage(ownerId);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve site usage for ownerid [%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

