/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.util.TextUtils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.simulfishgrowthdata.util.GCubeUtils;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseFilter.class);
    public static final String CTX_PARAM_DB_ENDPOINT_NAME = "DBEndpointName";
    public static final String CTX_PARAM_ADDITONAL_SIMILARITY_CONSTRAINT = "AdditionalSimilarityConstraint";
    static final String debugHibernateConfig = "debug.HibernateConfig";
    String dbEndpointName;
    public static String additionalSimilarityConstraint;

    public DatabaseFilter() {
        logger.error(String.format("DatabaseFilter ctor : test error", new Object[0]));
        logger.debug(String.format("DatabaseFilter ctor : test debug", new Object[0]));
        logger.trace(String.format("DatabaseFilter ctor : test trace", new Object[0]));
        System.out.println(String.format("DatabaseFilter ctor on system.out", new Object[0]));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug("in doFilter");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = httpRequest.getHeader(key);
            if (!logger.isDebugEnabled()) continue;
            logger.debug(String.format("Header [%s]=[%s]", key, value));
        }
        String dbhost = httpRequest.getHeader("dbhost");
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("dbhost [%s]", dbhost));
        }
        if (dbhost != null) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("the user used alternate connection: custom connection", new Object[0]));
            }
            String dbname = httpRequest.getHeader("dbname");
            String dbuser = httpRequest.getHeader("dbuser");
            String dbpass = httpRequest.getHeader("dbpass");
            GCubeUtils.prefillDBCredentials((String)dbhost, (String)dbname, (String)dbuser, (String)dbpass);
        } else {
            String endpoint = httpRequest.getHeader("dbendpooint");
            if (!TextUtils.isEmpty((CharSequence)endpoint)) {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("the user used alternate connection: custom database endpoint [%s]", endpoint));
                }
                this.dbEndpointName = endpoint;
            }
        }
        String scope = httpRequest.getHeader("scope");
        ScopeProvider.instance.set(scope);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("configuring Hibernate", new Object[0]));
        }
        HibernateUtil.configGently((String)this.dbEndpointName, (String)scope);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("configuring Hibernate - done", new Object[0]));
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig fConfig) throws ServletException {
        String debugHibernateConfigFilename;
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("DatabaseFilter init", new Object[0]));
        }
        this.dbEndpointName = fConfig.getInitParameter(CTX_PARAM_DB_ENDPOINT_NAME);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("DatabaseFilter [%s]=[%s]", CTX_PARAM_DB_ENDPOINT_NAME, this.dbEndpointName));
        }
        additionalSimilarityConstraint = fConfig.getInitParameter(CTX_PARAM_ADDITONAL_SIMILARITY_CONSTRAINT);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("DatabaseFilter [%s]=[%s]", CTX_PARAM_ADDITONAL_SIMILARITY_CONSTRAINT, additionalSimilarityConstraint));
        }
        if ((debugHibernateConfigFilename = fConfig.getInitParameter(debugHibernateConfig)) != null && !debugHibernateConfigFilename.isEmpty()) {
            HibernateUtil.debugLoadFromLocalXml = debugHibernateConfigFilename;
            logger.info(String.format("Using debug hibernate config [%s]", debugHibernateConfigFilename));
        }
    }
}

