/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.ModelerFull;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.ModelerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/ModelerFull")
public class ModelerFullUtil
extends BaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(ModelerFullUtil.class);

    @PUT
    @Consumes(value={"application/json"})
    public Response add(ModelerFull modelerFull, @DefaultValue(value="1") @QueryParam(value="createSamples") Long createSamples) throws Exception {
        System.out.println("createSamples " + createSamples);
        return new ModelerUtil().add(new Modeler((Modeler)modelerFull), createSamples);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response update(ModelerFull modelerFull, @DefaultValue(value="1") @QueryParam(value="createSamples") Long createSamples) throws Exception {
        System.out.println("createSamples " + createSamples);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("original %s", modelerFull));
        }
        Modeler copy = new Modeler((Modeler)modelerFull);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("copy %s", copy));
        }
        return new ModelerUtil().update(copy, createSamples);
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        return new ModelerUtil().delete(id);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public ModelerFull getModelerFull(@PathParam(value="id") Long id) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ModelerFullUtil().getModelerFull(id);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full modeler for [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/all/{ownerId}/{start}/{end}")
    public List<ModelerFull> getModelerFulls(@PathParam(value="ownerId") String ownerId, @PathParam(value="start") Integer start, @PathParam(value="end") Integer end, @QueryParam(value="status") List<Long> status, @QueryParam(value="species") Long species) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ModelerFullUtil().getModelerFulls(ownerId, start, end, status, species);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full modeler for ownerid [%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<ModelerFull> getModelerFulls(@PathParam(value="ownerId") String ownerId, @QueryParam(value="status") List<Long> status, @QueryParam(value="species") Long species) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ModelerFullUtil().getModelerFulls(ownerId, status, species);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full modeler for ownerid[%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/count/{ownerId}")
    public int getModelerFullCount(@PathParam(value="ownerId") String ownerId, @QueryParam(value="species") Long species) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ModelerFullUtil().getModelerFullCount(ownerId, species);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full modeler count for ownerid[%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

