package org.gcube.data.spd.asfis;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPool;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.CommonName;

public class Utils {

	//DERBY CONNECTION
	//	public static String dbURL = "jdbc:derby:classpath:FloraDB;create=true";
	//public static String dbURL = "jdbc:derby:FloraDB;create=true";

	static GCUBELog logger = new GCUBELog(Utils.class);


	//format date
	public static String createDate() {
		Calendar now = Calendar.getInstance();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		String date = format.format(now.getTime());
		return date;
	}

	public static String createCitation() {
		StringBuilder cit = new StringBuilder();
		cit.append(AsfisPlugin.citation);
		cit.append(createDate());
		return cit.toString();
	}

	public static String createCredits() {
		String cred = AsfisPlugin.credits;
		cred = cred.replace("XDATEX",createDate());	
		return cred;
	}

	//create commonNames List
	public static List<CommonName> setCommonNames(String englishName,
			String frenchName, String spanishName) {
		List<CommonName> commonNames = new ArrayList<CommonName>();
		commonNames.add(new CommonName(AsfisPlugin.ENG, englishName));
		commonNames.add(new CommonName(AsfisPlugin.FRA, frenchName));
		commonNames.add(new CommonName(AsfisPlugin.SPA, spanishName));
		return commonNames;
		
	}
	
	/**
	 * Return a ResultSet of scientific names
	 */
	public static ResultSet createResultSetByName(String scientificName) {

		ConnectionPool pool = null;
		ResultSet results = null;
		try {
			pool = ConnectionPool.getConnectionPool();

			String term = "%" + scientificName + "%";

			String query = "select TAXOCODE, Scientific_name, Author, Family, Order_rank, English_name, French_name, Spanish_name from "+ AsfisPlugin.table + " where UPPER(Scientific_name) like UPPER(?)";
			results =  pool.selectPrestatement(query, term);
		}
		catch (ConnectionPoolException e) {
			logger.error("ConnectionPoolException", e);
		}finally{

		}
		return results;
	}


}



