/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.asfis.capabilities;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPool;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class NamesMappingImpl
implements MappingCapability {
    GCUBELog logger = new GCUBELog(NamesMappingImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRelatedScientificNames(ObjectWriter<String> writer, String commonName) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = null;
            query = "select Scientific_name from asfis where UPPER(English_name) like UPPER(?) or UPPER(French_name) like UPPER(?) or UPPER(Spanish_name) like UPPER(?) ";
            if (query != null) {
                rs = pool.selectPrestatement(query, "%" + commonName + "%");
            }
            if (!writer.isAlive()) {
                return;
            }
            if (rs != null) {
                while (rs.next()) {
                    writer.write((Object)rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"SQL Error", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"SQL Error", (Throwable)ex);
            }
        }
    }
}

