/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.asfis.dbconnection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.gcube.data.spd.asfis.AsfisPlugin;
import org.gcube.data.spd.asfis.dbconnection.AsfisRecord;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPool;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsfisTable {
    private static Logger log = LoggerFactory.getLogger(AsfisTable.class);
    private ArrayList<String> fields = new ArrayList();
    private File tempFolder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean createDb() throws SQLException {
        try {
            int[] dimension = this.getDimensions();
            this.fillDb(dimension);
        }
        catch (SQLException e) {
            Boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            Boolean bl = false;
            return bl;
        }
        finally {
            if (this.tempFolder != null) {
                this.clearTmp(this.tempFolder);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillDb(int[] dimension) throws SQLException, IOException {
        log.info("Creating table asfis... ");
        ConnectionPool pool = null;
        Connection con = null;
        Boolean firstLine = true;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            InputStream file = AsfisPlugin.class.getResourceAsStream("/ASFIS.xls");
            HSSFWorkbook workbook = new HSSFWorkbook(file);
            HSSFSheet sheet = workbook.getSheetAt(0);
            Iterator rowIterator = sheet.iterator();
            String query = null;
            boolean result = false;
            PreparedStatement stmtInsert = null;
            while (rowIterator.hasNext()) {
                ArrayList<String> terms;
                Row row = (Row)rowIterator.next();
                if (firstLine.booleanValue()) {
                    this.getFields(row);
                    firstLine = false;
                    query = this.createTable(dimension);
                    result = pool.insertPreStatement(query);
                    if (result) continue;
                    log.error("problem creating table");
                    continue;
                }
                query = this.createInsertQuery();
                if (pool.preStatement(query, terms = this.getTerms(row), stmtInsert)) continue;
                log.error("error ");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ConnectionPoolException e) {
            log.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    private String createInsertQuery() {
        StringBuilder query = new StringBuilder();
        Boolean first = true;
        query.append("insert into asfis (");
        for (String field : this.fields) {
            if (!first.booleanValue()) {
                query.append(", ");
            } else {
                first = false;
            }
            query.append(field);
        }
        query.append(")");
        query.append(" values (");
        first = true;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!first.booleanValue()) {
                query.append(", ");
            } else {
                first = false;
            }
            query.append("?");
        }
        query.append(")");
        return query.toString();
    }

    private void getFields(Row row) {
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            this.fields.add(cell.toString());
        }
    }

    private ArrayList<String> getTerms(Row row) {
        ArrayList<String> terms = new ArrayList<String>();
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            terms.add(cell.toString());
        }
        return terms;
    }

    private String createTable(int[] dimension) {
        Boolean firstField = true;
        StringBuilder query = new StringBuilder();
        query.append("create table asfis (");
        int i = 0;
        for (String field : this.fields) {
            String newField;
            if (dimension[i] < 1) {
                dimension[i] = 1;
            }
            if (!firstField.booleanValue()) {
                query.append(", ");
            } else {
                firstField = false;
            }
            if (field.equals("3A_CODE")) {
                newField = field.replace("3", "three");
                this.fields.set(i, newField);
                query.append("threeA_CODE");
            } else if (field.equals("Order")) {
                newField = field.replace("Order", "Order_rank");
                this.fields.set(i, newField);
                query.append("Order_rank");
            } else {
                query.append(field);
            }
            query.append(" varchar(" + dimension[i] + ")");
            ++i;
        }
        query.append(")");
        return query.toString();
    }

    public int[] getDimensions() throws SQLException, IOException {
        int[] maxDimension = new int[]{};
        short size = 0;
        try {
            InputStream file = AsfisPlugin.class.getResourceAsStream("/ASFIS.xls");
            HSSFWorkbook workbook = new HSSFWorkbook(file);
            HSSFSheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (size == 0) {
                    size = row.getLastCellNum();
                    maxDimension = new int[size];
                }
                Iterator cellIterator = row.cellIterator();
                int i = 0;
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    if (cell.toString().length() > maxDimension[i]) {
                        maxDimension[i] = cell.toString().length();
                    }
                    ++i;
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return maxDimension;
    }

    private void clearTmp(File f) {
        if (f.exists()) {
            for (File c : f.listFiles()) {
                if (c.isDirectory()) {
                    this.clearTmp(c);
                }
                c.delete();
            }
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getAllRecords() {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select * from figis";
            results = pool.selectPrestatement(query, null);
        }
        catch (Throwable e) {
            log.error("general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsfisRecord getRecordByID(String id) {
        log.info("getRecordByID " + id);
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet result = null;
        AsfisRecord record = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String three_alpha_code = "%" + id + "%";
            String query = "select * from asfis where UPPER(three_alpha_code) like UPPER(?)";
            result = pool.selectPrestatement(query, three_alpha_code);
            if (result.next()) {
                record = new AsfisRecord(result);
            }
        }
        catch (Throwable e) {
            log.error("general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                log.error("sql Error", (Throwable)ex);
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createTabUpdates() throws SQLException {
        log.info("Creating table figis... ");
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "create table updates (id serial NOT NULL PRIMARY KEY, date date)";
            boolean result = pool.insertPreStatement(query);
            if (!result) {
                log.error("problem creating table");
            }
        }
        catch (ConnectionPoolException e) {
            log.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrders() {
        ConnectionPool pool = null;
        ResultSet result = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select distinct(order_rank) from asfis where order_rank is not null";
            result = pool.selectPrestatement(query, null);
            if (result != null) {
                while (result.next()) {
                    String name = result.getString(1);
                    String queryInsert = "insert into asfis (Scientific_name, parent_id, rank) values ('" + name + "' , '" + 12422 + "' , 'Order')";
                    if (pool.insertPreStatement(queryInsert)) continue;
                    log.error("error ");
                }
            }
        }
        catch (Throwable e) {
            log.error("general Error", e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                log.error("sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFamilies() {
        ConnectionPool pool = null;
        ResultSet result = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select family, order_rank from asfis where family!='' group by family, order_rank order by family";
            result = pool.selectPrestatement(query, null);
            if (result != null) {
                while (result.next()) {
                    String family = result.getString(1);
                    String order = result.getString(2);
                    int idOrder = this.getRankID(order, "Order");
                    String queryInsert = "insert into asfis (Scientific_name, parent_id, rank) values ('" + family + "' , '" + idOrder + "' , 'Family')";
                    if (pool.insertPreStatement(queryInsert)) continue;
                    log.error("error ");
                }
            }
        }
        catch (Throwable e) {
            log.error("general Error", e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                log.error("sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateParentSpecies() {
        ConnectionPool pool = null;
        ResultSet result = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select id, family, order_rank from asfis where rank='Species'";
            result = pool.selectPrestatement(query, null);
            if (result != null) {
                while (result.next()) {
                    String id = result.getString(1);
                    if (id == "") continue;
                    String family = result.getString(2);
                    String order = result.getString(3);
                    int parentID = 0;
                    parentID = !family.equals("") ? this.getRankID(family, "Family") : this.getRankID(order, "Order");
                    String queryInsert = "UPDATE asfis set parent_id = " + parentID + " where id =" + id + "";
                    if (pool.insertPreStatement(queryInsert)) continue;
                    log.error("error ");
                }
            }
        }
        catch (Throwable e) {
            log.error("general Error", e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                log.error("sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRankID(String order, String rank) {
        ConnectionPool pool = null;
        ResultSet result = null;
        int id = 0;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select id from asfis where Scientific_name = '" + order + "' and rank='" + rank + "'";
            result = pool.selectPrestatement(query, null);
            if (result.next()) {
                id = result.getInt(1);
            }
        }
        catch (Throwable e) {
            log.error("general Error", e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                log.error("sql Error", (Throwable)ex);
            }
        }
        return id;
    }
}

