/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.asfis;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPool;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.CommonName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    static Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String createDate() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(now.getTime());
        return date;
    }

    public static String createCitation() {
        StringBuilder cit = new StringBuilder();
        cit.append("Accessed through: ASFIS List of Species for Fishery Statistics Purposes at http://www.fao.org/fishery/collection/asfis/en on ");
        cit.append(Utils.createDate());
        return cit.toString();
    }

    public static String createCredits() {
        String cred = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with ASFIS List of Species for Fishery Statistics Purposes (http://www.fao.org/fishery/collection/asfis/en)";
        cred = cred.replace("XDATEX", Utils.createDate());
        return cred;
    }

    public static List<CommonName> setCommonNames(String englishName, String frenchName, String spanishName, String arabic_name, String chinese_name, String russian_name) {
        ArrayList<CommonName> commonNames = null;
        try {
            commonNames = new ArrayList<CommonName>();
            if (englishName != null && !englishName.isEmpty()) {
                commonNames.add(new CommonName("English", englishName));
            }
            if (frenchName != null && !frenchName.isEmpty()) {
                commonNames.add(new CommonName("French", frenchName));
            }
            if (spanishName != null && !spanishName.isEmpty()) {
                commonNames.add(new CommonName("Spanish", spanishName));
            }
            if (arabic_name != null && !arabic_name.isEmpty()) {
                commonNames.add(new CommonName("Arabic", arabic_name));
            }
            if (chinese_name != null && !chinese_name.isEmpty()) {
                commonNames.add(new CommonName("Chinese", chinese_name));
            }
            if (russian_name != null && !russian_name.isEmpty()) {
                commonNames.add(new CommonName("Russian", russian_name));
            }
        }
        catch (Exception e) {
            logger.error("Error creating common names list ", (Throwable)e);
        }
        return commonNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet createResultSetByName(String scientificName) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String term = "%" + scientificName + "%";
            String query = "select id, Scientific_name, Author, English_name, French_name, Spanish_name, parent_id, TAXOCODE, ISSCAAP, threeA_CODE, rank, Arabic_name, Chinese_name, Russian_name from asfis where UPPER(Scientific_name) like UPPER(?)";
            results = pool.selectPrestatement(query, term);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet createResultSetByID(String id) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select Scientific_name, parent_id, rank from asfis where id = " + id;
            results = pool.selectPrestatement(query, null);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet createCompleteResultSetByID(String id) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select Scientific_name, Author, English_name, French_name, Spanish_name, parent_id, TAXOCODE, ISSCAAP, threeA_CODE, rank, Arabic_name, Chinese_name, Russian_name from asfis where id = " + id;
            results = pool.selectPrestatement(query, null);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        return results;
    }
}

