/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingUtils {
    private static Logger log = LoggerFactory.getLogger(MappingUtils.class);

    public static Map<String, Object> getObjectMapping(String query) throws Exception {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)clientConfig);
        WebResource target = client.resource(query);
        String response = (String)((WebResource.Builder)target.type("application/json").acceptLanguage(new Locale[]{Locale.ENGLISH})).get(String.class);
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue((Reader)new StringReader(response), Map.class);
    }

    public static LinkedList<HashMap<String, Object>> getObjectList(String query) throws Exception {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)clientConfig);
        WebResource target = client.resource(query);
        String response = (String)((WebResource.Builder)target.type("application/json").acceptLanguage(new Locale[]{Locale.ENGLISH})).get(String.class);
        ObjectMapper mapper = new ObjectMapper();
        return (LinkedList)mapper.readValue((Reader)new StringReader(response), (TypeReference)new TypeReference<LinkedList<HashMap<String, Object>>>(){});
    }

    public static String getAsString(Map<String, Object> map, String key) {
        if (!map.containsKey(key)) {
            return null;
        }
        return (String)map.get(key);
    }

    public static Double getAsDouble(Map<String, Object> map, String key) {
        if (!map.containsKey(key)) {
            return 0.0;
        }
        return (Double)map.get(key);
    }

    public static Integer getAsInteger(Map<String, Object> map, String key) {
        if (!map.containsKey(key)) {
            return 0;
        }
        return (Integer)map.get(key);
    }

    public static Long getAsLong(Map<String, Object> map, String key) {
        if (!map.containsKey(key)) {
            return 0L;
        }
        return (Long)map.get(key);
    }

    public static Calendar getAsCalendar(Map<String, Object> map, String key) {
        if (!map.containsKey(key)) {
            return null;
        }
        return MappingUtils.parseCalendar((String)map.get(key));
    }

    public static Calendar parseCalendar(String date) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(df.parse(date));
            return calendar;
        }
        catch (ParseException e) {
            log.warn("DateModified discarded (" + date + ")");
            return null;
        }
    }
}

