/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.spd.havingengine.exl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.gcube.dataaccess.spd.havingengine.exl.HavingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HavingFunctions {
    protected static Logger logger = LoggerFactory.getLogger(HavingFunctions.class);
    protected static Map<String, XPathExpression> expression_cache = new HashMap<String, XPathExpression>();
    protected HavingContext<?> context;

    public HavingFunctions(JexlContext context) {
        this.context = (HavingContext)context;
    }

    public boolean xpath(String xpath) throws SAXException, IOException, XPathExpressionException {
        logger.debug("xpath {} ", (Object)xpath);
        Document doc = this.context.getDocument();
        XPathExpression expression = this.getExpression(xpath);
        boolean eval = (Boolean)expression.evaluate(doc, XPathConstants.BOOLEAN);
        logger.trace("xpath eval: {}", (Object)eval);
        return eval;
    }

    protected XPathExpression getExpression(String xpathExpression) throws XPathExpressionException {
        logger.trace("getExpression xpathExpression {}", (Object)xpathExpression);
        XPathExpression expression = expression_cache.get(xpathExpression);
        if (expression == null) {
            logger.trace("Building xpath expression");
            expression = this.buildExpression(xpathExpression);
            expression_cache.put(xpathExpression, expression);
        } else {
            logger.trace("XPath expression already cached");
        }
        return expression;
    }

    protected XPathExpression buildExpression(String xpathExpression) throws XPathExpressionException {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(xpathExpression);
        return expr;
    }

    public boolean exl(String exlExpression) {
        logger.debug("exl exlExpression: {}", (Object)exlExpression);
        JexlEngine engine = this.context.getEngine();
        Expression expression = engine.createExpression(exlExpression);
        boolean eval = (Boolean)expression.evaluate(this.context);
        logger.trace("xpath eval: {}", (Object)eval);
        return eval;
    }

    public boolean lucio(String expression) {
        logger.debug("lucio expression: {}", (Object)expression);
        boolean eval = "oh".equalsIgnoreCase(expression) || "fro".equalsIgnoreCase(expression);
        logger.trace("xpath eval: {}", (Object)eval);
        return eval;
    }
}

