/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.spd.havingengine.exl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.ObjectContext;
import org.apache.commons.jexl2.ReadonlyContext;
import org.gcube.dataaccess.spd.havingengine.exl.HavingMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class HavingContext<T>
implements JexlContext {
    protected static Logger logger = LoggerFactory.getLogger(HavingContext.class);
    protected static XStream XSTREAM = new XStream(){

        protected MapperWrapper wrapMapper(MapperWrapper next) {
            return new HavingMapper((Mapper)next);
        }
    };
    protected static DocumentBuilder builder;
    protected JexlContext context;
    protected JexlEngine engine;
    protected T wrapped;
    protected Document doc;

    public HavingContext(JexlEngine engine, T wrapped) {
        this.context = new ReadonlyContext((JexlContext)new ObjectContext(engine, wrapped));
        this.wrapped = wrapped;
        this.engine = engine;
    }

    public JexlEngine getEngine() {
        return this.engine;
    }

    public T getWrapped() {
        return this.wrapped;
    }

    public Document getDocument() {
        if (this.doc == null) {
            this.doc = this.buildDocument();
        }
        return this.doc;
    }

    protected Document buildDocument() {
        try {
            String xml = XSTREAM.toXML(this.wrapped);
            logger.trace("xml {}", (Object)xml);
            ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
            Document doc = builder.parse(stream);
            return doc;
        }
        catch (Exception e) {
            logger.error("Error converting item to XML", (Throwable)e);
            throw new RuntimeException("An error occurred building the document", e);
        }
    }

    public Object get(String name) {
        return this.context.get(name);
    }

    public void set(String name, Object value) {
        this.context.set(name, value);
    }

    public boolean has(String name) {
        return this.context.has(name);
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error initializing the builder", e);
        }
    }
}

